<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title> Liquidación # {{$pdfData->id}}</title>
    <style>
        /* Estilos generales */
        @page {
            margin: 1cm;
        }

        /* @import url("https://fonts.googleapis.com/css2?family=Work+Sans:wght@200;400;500;600;700;800;900&display=swap"); */

        body {
            min-width: 100px;
            min-height: 100%;
            font-family: "Work Sans", sans-serif;
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            font-smoothing: antialiased;
            line-height: 1.5;
            font-size: 14px;
            color: #333;
            background-color: #fff;
        }

        /* Header */
        header {
            position: relative;
            @if (!isset($configuration))
background: #9747ff;
            @else
background: {{ $configuration->brand_color }};
            @endif
margin-top: -1cm;
            margin-left: -40px;
            width: 120%;
            z-index: 1;
        }

        .header-container {
            width: 930px;
            height: 110px;
            @if (!isset($configuration))
background: #9747ff;
            @else
background: {{ $configuration->brand_color }};
            @endif
margin: 0 auto;
            padding: 0 20px;
            z-index: 1;
        }

        .logo {
            width: 190px;
            margin-top: 45px;
        }

        .text {
            font-size: 25px;
            font-weight: 600;
            line-height: 29.33px;
            color: white;
            position: absolute;
            top: 45px;
            left: 440px;
        }

        /* Card */
        .card-container {
            position: absolute;
            z-index: 2;
            margin: 0 -5px;
            background-color: #fff;
            width: 715px;
            height: 80px;
            margin-top: -50px;
            margin-lefteft: 34px;
            padding: 6px;
            border-radius: 6px;
            border: 1px #ECECEC solid;
            gap: 20px;
        }

        .card-container:after {
            content: "";
            display: table;
            clear: both;
        }

        .card-content-domiciliary {
            float: left;
            width: 35%;
            padding: 0 18px;
        }

        .card-content {
            float: left;
            width: 25%;
            padding: 0 10px;
        }

        .card {
            box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2);
            padding-top: 12px;
            text-align: left;
            background-color: #ffffff;
        }

        .ico-card {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            @if (!isset($configuration))
background: #9747ff;
            @else
background: {{ $configuration->brand_color }};
            @endif
position: relative;
            margin-left: -5px
        }

        .ico-card img {
            display: block;
            width: 20px;
            height: 20px;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .title-card {
            color: #1E1D20;
            font-size: 13px;
            font-weight: 600;
            line-height: 13.65px;
            letter-spacing: 0em;
            text-align: left;
            margin-bottom: 4px;
        }

        .text-card {
            color: #1E1D20;
            font-size: 13px;
            font-weight: 400;
            line-height: 13.65px;
            letter-spacing: 0em;
            text-align: left;
            margin-top: 0;
            margin-right: 2rem;
        }

        .title-card,
        .text-card {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        /* Table */
        main {
            margin-top: 0;
            margin-bottom: 1.5cm;
            position: relative;
        }

        table {
            border-spacing: 0;
            border-collapse: collapse;
            background-color: transparent;
        }

        td,
        th {
            padding: 0;
        }

        th {
            text-align: left;
        }

        .table {
            width: 100%;
            max-width: 100%;
            margin-bottom: 20px;
        }

        .table>thead>tr>th,
        .table>tbody>tr>th,
        .table>tfoot>tr>th,
        .table>thead>tr>td,
        .table>tbody>tr>td,
        .table>tfoot>tr>td {
            padding: 0px;
            line-height: 1.02857143;
            vertical-align: top;
        }

        .table>thead>tr>th {
            vertical-align: bottom;
        }

        .table>caption+thead>tr:first-child>th,
        .table>colgroup+thead>tr:first-child>th,
        .table>thead:first-child>tr:first-child>th,
        .table>caption+thead>tr:first-child>td,
        .table>colgroup+thead>tr:first-child>td,
        .table>thead:first-child>tr:first-child>td {
            border-top: 0;
        }

        .table>tbody+tbody {}

        .table .table {
            background-color: #ffffff;
        }

        .table-condensed>thead>tr>th,
        .table-condensed>tbody>tr>th,
        .table-condensed>tfoot>tr>th,
        .table-condensed>thead>tr>td,
        .table-condensed>tbody>tr>td,
        .table-condensed>tfoot>tr>td {
            padding: 0px;
        }

        .table-bordered {
            border: 1px solid #ECECEC;
        }

        .table-bordered>thead>tr>th,
        .table-bordered>tbody>tr>th,
        .table-bordered>tfoot>tr>th,
        .table-bordered>thead>tr>td,
        .table-bordered>tbody>tr>td,
        .table-bordered>tfoot>tr>td {
            border: 1px solid #ECECEC;
        }

        .table-bordered>thead>tr>th,
        .table-bordered>thead>tr>td {
            border-bottom-width: 2px;
        }

        .table-striped>tbody>tr:nth-of-type(odd) {
            opacity: 0.4;
            border-radius: 4px;
            @if (!isset($configuration))
background-color: rgba(151, 71, 255, 0.4); /* Color de fondo predeterminado con opacidad al 40% */
            @else
background-color: rgba(169, 169, 169, 0.4);
        @endif
}

        table col[class*="col-"] {
            position: static;
            display: table-column;
            float: none;
        }

        table td[class*="col-"],
        table th[class*="col-"] {
            position: static;
            display: table-cell;
            float: none;
        }

        .collapse {
            display: none;
        }

        .collapse.in {
            display: block;
        }

        tr.collapse.in {
            display: table-row;
        }

        tbody.collapse.in {
            display: table-row-group;
        }

        .table-content {
            margin-top: 3rem;
            margin-left: 0px;
            border-top: 1px solid #ECECEC;
            padding-top: 20px;
            padding-bottom: 10px;
        }

        .table-label {
            font-size: 12px;
            font-weight: 600;
            line-height: 13.65px;
            letter-spacing: 0em;
            text-align: left;
            color: #A1A1A1;
            padding-left: 10px;
        }

        .table-text {
            font-size: 13px;
            font-weight: 400;
            line-height: 13.65px;
            letter-spacing: 0em;
            text-align: left;
            color: #1E1D20;
            padding-left: 10px;
        }

        td.reference,
        td.phone,
        td.name {
            width: 120px;
        }

        td.total {
            padding-right: 10px !important;
        }

        td.reference,
        td.name,
        td.address,
        td.phone,
        td.total {
            vertical-align: middle !important;
        }

        .table-total-container {
            width: 715px;
            height: 86px;
            top: 596px;
            left: 20px;
            padding: 26px, 16px, 26px, 16px;
            border: 1px, 0px, 0px, 0px;
            justify: space-between;
            background-color: #F6F6F6;
        }

        .table-cant-content {
            float: left;
            margin-top: 0;
            font-size: 13px;
            font-weight: 600;
            letter-spacing: 0em;
            text-align: left;
            color: #1E1D20;
            padding-left: 20px;
        }

        .table-cant-label {
            margin-top: 0;
            font-size: 13px;
            font-weight: 600;
            letter-spacing: 0em;
            text-align: left;
            color: #1E1D20;
        }

        .table-cant-text {
            margin-top: 0;
            font-size: 23px;
            font-weight: 600;
            line-height: 27px;
            letter-spacing: 0em;
            text-align: left;
            @if (!isset($configuration))
                color: #9747ff;
            @else
                color: {{ $configuration->brand_color }};
            @endif
        }

        .table-total-content {
            float: right;
            padding-right: 20px;
        }

        .table-total-label {
            margin-top: 0;
            font-size: 13px;
            font-weight: 600;
            letter-spacing:
                0em; text-align: left;
            color: #1E1D20;
            padding-left: 10px;
        }

        .table-total-text {
            margin-top: 0;
            font-size: 23px;
            font-weight: 600;
            line-height: 27px;
            letter-spacing: 0em;
            text-align: left;
            @if (!isset($configuration))
                color: #9747ff;
            @else
                color: {{ $configuration->brand_color }};
            @endif
        }

        /* Footer */
        footer {
            position: relative;
            bottom: 0px;
            left: 0px;
            right: 0px;
            height: 200px;
            margin-right: 0cm;
            width: 100%;
            color: #979A9A;
        }

        .footer-section {
            position:relative;
            height: 100%; width: 100%;
        }

        .footer-content {
            margin-top: 10px;
            background-color: transparent !important;
            position:relative;
            z-index: 9999999;
            height: 50px;
        }

        .onexdelivery-logo {
            font-size: 13px;
            font-weight: 400;
            line-height: 13.65px;
            letter-spacing: 0em;
            text-align: center;
            color: #1E1D20;
        }

        .domiciliary-table {
            width: 100%;
            padding-bottom: 10px;
        }

        .domiciliary-td {
            padding: 10px;
            text-align: left;
            width: 33.33%;
        }

        .domiciliary-signature {
            font-size: 13px;
            font-weight: 600;
            line-height: 13.65px;
            letter-spacing: 0em;
            color: #1E1D20;
        }

        .domiciliary-name {
            font-size: 13px;
            font-weight: 600;
            line-height: 13.65px;
            letter-spacing: 0em;
            color: #1E1D20;
            margin-top: 50px;
            display: block;
            border-top: 1px solid #ECECEC;
            padding-top: 10px;
        }

        .domiciliaty-label {
            font-size: 13px;
            font-weight: 400;
            line-height: 13.65px;
            letter-spacing: 0em;
            text-align: left;
            color: #1E1D20;
        }

        .signature {
            padding-bottom: 20px;
        }

    </style>
</head>
<body>
<header>
    <div class="header-container">
        <div class="logo">
            @if (!isset($configuration))
                <img src="https://app.onexdelivery.com/img/onexdelivery/onex_icon_black.svg" alt="Logo">
            @else
                <img style="width: 100px;" src="{{ $configuration->logo }}" alt="Logo">
            @endif
        </div>
        <div class="text">
            <strong>Liquidación {{$pdfData->id}}</strong>
        </div>
    </div>
</header>
<div class="card-container">
    <div class="card-content">
        <div class="card">
            <table>
                <tr>
                    <td style="padding-right: 10px;">
                        <div class="ico-card">
                            <img src="./images/icons/icon_calendario.svg" alt="">
                        </div>
                    </td>
                    <td>
                        <div class="text-container">
                            <p class="title-card">
                                <strong> Fecha: </strong>
                            </p>
                            <p class="text-card">
                                {{ $pdfData->created_at->format('Y/m/d') }}
                            </p>
                        </div>
                    </td>

                    <td>
                        <div class="text-container">
                            <p class="title-card">
                                <strong> Tipo de reporte: </strong>
                            </p>
                            <p class="text-card">
                                @if(isset($pdfData->sender))
                                    por Remitente
                                @else
                                    Global
                                @endif
                            </p>
                        </div>
                    </td>

                    @if(isset($pdfData->sender))
                        <td>
                            <div class="text-container">
                                <p class="title-card">
                                    <strong> Remitente: </strong>
                            </p>
                            <p class="text-card">
                                {{ $pdfData->sender }}
                            </p>
                        </div>
                    </td>
                    @endif

                </tr>
            </table>
        </div>
    </div>
</div>
<main>

    @if(isset($pdfData->has_dropshipper) && $pdfData->has_dropshipper)
        <table class="table table-striped table-content">
            <thead>
                <tr class="table">
                    <th><p class="table-label"><b>Guia</b></p></th>
                    <th><p class="table-label"><b>Estado</b></p></th>
                    <th><p class="table-label"><b>Fecha</b></p></th>
                    <th><p class="table-label"><b>Fecha de entrega</b></p></th>
                    <th><p class="table-label"><b>Ciudad</b></p></th>
                    <th><p class="table-label"><b>Remitente</b></p></th>
                    <th><p class="table-label"><b>Dropshipper</b></p></th>
                    <th><p class="table-label"><b>COD</b></p></th>
                    <th><p class="table-label"><b>Costos logisticos</b></p></th>
                    <th><p class="table-label"><b>Total liquidado</b></p></th>
                    <th><p class="table-label"><b>L. Drop</b></p></th>
                    <th><p class="table-label"><b>L. Prov</b></p></th>
                    <th><p class="table-label"><b>Método de pago</b></p></th>
                </tr>
            </thead>
            <tbody>
                @foreach($pdfData->domicilios as $domicilio)
                    <tr style="position: relative">
                        <td class="text-left"><p class="table-text">{{ $domicilio->reference }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->status }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->date }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->delivery_date }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->city }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->sender }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->name_dropshipper }}</p></td>
                        <td class="text-left"><p class="table-text">$ {{ number_format($domicilio->collection_value, 2, ',', '.') }}</p></td>
                        <td class="text-left"><p class="table-text">$ {{ number_format($domicilio->logistic_cost, 2, ',', '.') }}</p></td>
                        <td class="text-left"><p class="table-text">$ {{ number_format($domicilio->total, 2, ',', '.') }}</p></td>
                        <td class="text-left"><p class="table-text">$ {{ number_format($domicilio->dropshipper_settlement, 2, ',', '.') }}</p></td>
                        <td class="text-left"><p class="table-text">$ {{ number_format($domicilio->provider_settlement, 2, ',', '.') }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->payment_method ?? ""}}</p></td>
                    </tr>
                @endforeach
                <tr>
                    <td colspan="7" class="text-right"></td>
                    <td class="text-left"><p class="table-text">$ {{ number_format($totalCollectionValue, 2, ',', '.') }}</p></td>
                    <td class="text-left"><p class="table-text">$ {{ number_format($totalOperationCost, 2, ',', '.') }}</p></td>
                    <td class="text-left"><p class="table-text">$ {{ number_format($totalTotal, 2, ',', '.') }}</p></td>
                </tr>
                <tr>
                    <td colspan="6" class="text-right"><strong>Total Domicilios: {{ $pdfData->totalDomicilios }}</strong></td>
                </tr>
            </tbody>
        </table>
    @else
        <table class="table table-striped table-content">
            <thead>
                <tr class="table">
                    <th><p class="table-label"><b>Guia</b></p></th>
                    <th><p class="table-label"><b>Estado</b></p></th>
                    <th><p class="table-label"><b>Fecha</b></p></th>
                    <th><p class="table-label"><b>Fecha de entrega</b></p></th>
                    <th><p class="table-label"><b>Ciudad</b></p></th>
                    <th><p class="table-label"><b>Remitente</b></p></th>
                    <th><p class="table-label"><b>COD</b></p></th>
                    @if($isComission)
                        <th><p class="table-label"><b>Com. Recaudo</b></p></th>
                    @endif
                    @if($isFullfillment)
                        <th><p class="table-label"><b>Fullfilment</b></p></th>
                    @endif
                    <th><p class="table-label"><b>Ultima milla</b></p></th>
                    <th><p class="table-label"><b>Total liquidado</b></p></th>
                    <th><p class="table-label"><b>Método de pago</b></p></th>
                </tr>
            </thead>
            <tbody>
                @foreach($pdfData->domicilios as $domicilio)
                    <tr style="position: relative">
                        <td class="text-left"><p class="table-text">{{ $domicilio->reference }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->status }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->date }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->delivery_date }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->city }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->sender }}</p></td>
                        <td class="text-left"><p class="table-text">$ {{ number_format($domicilio->collection_value, 2, ',', '.') }}</p></td>
                        @if($isComission)
                            <td class="text-left"><p class="table-text">$ {{ number_format($domicilio->collection_comission, 2, ',', '.') }}</p></td>
                        @endif
                        @if($isFullfillment)
                            <td class="text-left"><p class="table-text">$ {{ number_format($domicilio->fullfilment, 2, ',', '.') }}</p></td>
                        @endif
                        <td class="text-left"><p class="table-text">$ {{ number_format($domicilio->last_mille, 2, ',', '.') }}</p></td>
                        <td class="text-left"><p class="table-text">$ {{ number_format($domicilio->total, 2, ',', '.') }}</p></td>
                        <td class="text-left"><p class="table-text">{{ $domicilio->payment_method ?? ""}}</p></td>
                    </tr>
                @endforeach
                <tr>
                    <td colspan="6" class="text-right"></td>
                    <td class="text-left"><p class="table-text">$ {{ number_format($totalCollectionValue, 2, ',', '.') }}</p></td>
                    @if($isComission)
                        <td class="text-left"><p class="table-text">$ {{ number_format($totalCollectionCommission, 2, ',', '.') }}</p></td>
                    @endif
                    @if($isFullfillment)
                        <td class="text-left"><p class="table-text">$ {{ number_format($totalFullfilment, 2, ',', '.') }}</p></td>
                    @endif
                    <td class="text-left"><p class="table-text">$ {{ number_format($totalLastMille, 2, ',', '.') }}</p></td>
                    <td class="text-left"><p class="table-text">$ {{ number_format($totalTotal, 2, ',', '.') }}</p></td>
                </tr>
                <tr>
                    <td colspan="6" class="text-right"><strong>Total Domicilios: {{ $pdfData->totalDomicilios }}</strong></td>
                </tr>
            </tbody>
        </table>
    @endif

</main>
<footer>
    <section class="footer-section">
        <div class="row footer-content">
            <table class="domiciliary-table">
                <tr>
                    <td class="domiciliary-td">
                        <center>
                                    <span class="domiciliary-signature">
                                        <b>FIRMA</b>
                                    </span>
                            <span class="domiciliary-name signature">
                                        <b>Director de bodega</b>
                                    </span>
                        </center>
                    </td>
                    <td class="domiciliary-td">
                        <center>
                                    <span class="domiciliary-signature">
                                        <b>FIRMA</b>
                                    </span>
                            <span class="domiciliary-name signature">
                                        <b>Seguridad</b>
                                    </span>
                        </center>
                    </td>
                </tr>
            </table>
            <p class="onexdelivery-logo" style="text-align:center;">
                &copy; {{ isset($configuration) ? $configuration->brand_name : 'OnexDelivery'  }} <?php echo date("Y"); ?>
            <p class="pagenum" style="color: #838383 !important;">
                <script type="text/php">
								if ( isset($pdf) ) {
									$pdf->page_script('
										$font = $fontMetrics->get_font("Arial, Helvetica, sans-serif", "normal");
										$pdf->text(490, 777, "Pág. $PAGE_NUM de $PAGE_COUNT", $font, 10);
									');
								}
							</script>
            </p>
            </p>
        </div>
    </section>
</footer>
</body>
</html>
