<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Guía # {{ $order->reference }} </title>
    <style>
        @page { margin: 0px !important; }
        @import url('https://fonts.googleapis.com/css2?family=Work+Sans&display=swap');
        body {
            margin: 0px !important;
            font-family: "Work Sans", sans-serif;
        }

        .table {
            width: 100% !important;
        }

        table, th, td {
            border-collapse: collapse;
        }

        p {
            height: 6px !important;
            line-height: 10px;
        }

        .title {
            color: #000 !important;
            font-size: 11px !important;
        }

        .number-guide {
            font-size: 12px !important;
            font-weight: 600 !important;
        }

        .address {
            color: #000 !important;
            font-size: 10px !important;
        }

        .address-complete {
            color: #000;
            font-size: 10px;
            font-weight: 400;
        }

        .auto-height {
            height: auto;
        }

        .city {
            color: #000;
            font-size: 25px;
        }

        .number-city {
            color: #000;
            text-align: center;
            font-size: 16px;
            font-weight: 600;
        }

        .total {
            color: #000;
            text-align: center;
            font-size: 12px;
        }

        .totalAmount {
            color: #000;
            font-size: 14px;
            text-align: center;
            font-weight: 800;
        }

        .contentTitle {
            color: #000;
            font-size: 10px;
        }

        .contentProduct {
            color: #000;
            font-size: 10px;
            font-weight: normal !important;
        }
    </style>
</head>
<body style="margin: 0;">
    <table class="table" style="padding: 0 !important; margin-top: 0px">
        <tbody style="padding: 0px !important">
           <tr>
                <td style="width: 50%;">
                    <div style="width: 100%; height: 50px; padding: 14px 0px ; border: 1px solid; border-right: 1px solid black">
                        <table style="width: 100%;">
                            <tr>
                                <td style="padding: 5px 8px; width: 20px">
                                    @if (!$configuration)
                                        <img width="24px" height="24px" style="padding: 4px 8px;" src="https://app.onexdelivery.com/img/onexdelivery/onex_icon_black.svg">
                                        @else
                                        <img width="24px" height="24px" style="padding: 4px 8px;" src="{{ $configuration->logo }}">
                                    @endif
                                </td>
                                <td>
                                    <div class="title" style="margin-top: 0px;">
                                        <b>Guía N°</b>
                                    </div>
                                    <div  class="number-guide" style="margin-top: -0px;">
                                        {{ $order->reference }}
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div style="width: 100%; height: 66px; border: 1px solid; border-top: 0px solid black; border-right: 1px solid black; line-height: 10px !important">
                        <div style="height: 50px; padding-left: 16px; padding-top: 14px">
                            <div class="address">
                                <b>
                                    Dirección
                                </b>
                            </div>
                            <div>
                                @php
                                    $address = "{$order->Client->address} {$order->Client->city_name}, {$order->Client->getho}";
                                @endphp
                                <b style="font-size: 10px; margin-top: -10px; font-weight: normal">
                                    {{ Str::substr($address, 0, 100) }}
                                </b>
                            </div>
                        </div>
                    </div>
                </td>
                <td style="width: 50%; background:">
                    <div style="border: 1px solid black; height: 145px; border-left: 0px solid black">
                        <div style="border-bottom: 1px solid black; border-right: 1px solid;width: 50%; height: 90px">
                            <center>
                                <img  src="data:image/png;base64, {!! base64_encode($qrCode) !!}" style="width: 60px; height: 60px; margin: 10px auto">
                           </center>
                        </div>
                        <div style="border-bottom: 1px solid black; width: 50%; height: 90px; margin-top: -91px; float: right;">
                            <center>
                                <div class="city" style="margin-top: 10px">
                                    <b>
                                        {{ $order->Client->City ? strtoupper($order->Client->City->abbreviation) : $order->id }}
                                    </b>
                               </div>
                               <div class="number-city">
                                    <b>
                                        {{ $order->Client->Zone ? strtoupper($order->Client->Zone->code) : $order->id }}
                                    </b>
                               </div>
                           </center>
                        </div>
                        <div style="width: 100% !important;">
                            <div class="total" style="width: 100%; background-color:">
                                <p style="margin-top: -10px">
                                   <center>
                                        <b>
                                            Recaudar
                                        </b>
                                   </center>
                                </p>
                            <div class="totalAmount" style="width: 100%; text-align: center">
                                <b>
                                {{!is_null($configuration) ? $configuration->getCurrencySimbolAttribute() : '$'}}{{ number_format($order->total, 2, ',', '.') }}
                                </b>
                            </div>
                        </div>
                    </div>
                </td>
           </tr>
        </tbody>
    </table>
    <table class="table" style="padding: 0 !important; margin-top: -3px">
        <tbody style="padding: 0px !important">
            <tr>
                <td>
                    <div style="height: 50px; width: 90.8%;padding: 14px 16px 14px 16px; border-bottom: 1px solid black; border-right: 1px solid black; border-left: 1px solid black">
                        <span class="contentTitle">
                            <b>
                                Contenido
                            </b>
                            <p style="margin-top: 0px">
                                <span class="contentProduct">
                                    <b style="font-weight: 400">
                                        @if(isset($order->content)
                                        && is_array(json_decode($order->content)))
                                        @php
                                            $products = json_decode($order->content);
                                        @endphp
                                        @if(count($products) > 0)
                                            <ul>
                                                @foreach($products as $product)
                                                    <li>{{ $product->name ?? '' }} ({{ $product->quantity ?? '' }})</li>
                                                @endforeach
                                            </ul>
                                        @endif
                                    @else
                                        {{$order->content}}
                                    @endif
                                    </b>
                                </span>
                            </p>
                        </span>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
    <table class="table" style="padding: 0 !important; margin-top: -3px">
        <tbody style="padding: 0px !important">
            <tr>
                <td style="width: 50%">
                    <div style="width: 83.5%; padding: 14px 16px 14px 16px; border-bottom: 1px solid black; border-right: 0px solid black; border-left: 1px solid black">
                        <span class="contentTitle">
                            <b>
                                Remitente
                            </b>
                            <p style="margin-top: 0px">
                                <span class="contentProduct">
                                    <b style="font-weight: 400">
                                        {{ $order->logSender ? $order->logSender->name : '' }}, Tel: {{ $order->logSender ? $order->logSender->phone : '' }}
                                    </b>
                                </span>
                            </p>
                        </span>
                    </div>
                </td>
                <td style="width: 50%">
                    <div style="width: 82%; padding: 14px 16px 14px 16px; border-bottom: 1px solid black; border-right: 1px solid black; border-left: 0px solid black">
                        <span class="contentTitle">
                            <b>
                                Domiciliario
                            </b>
                            <p style="margin-top: 0px">
                                <span class="contentProduct">
                                    <b style="font-weight: 400">
                                        {{ $order->Domiciliario ? $order->Domiciliario->name : '' }}
                                    </b>
                                </span>
                            </p>
                        </span>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
    <table class="table" style="padding: 0 !important; margin-top: -3px">
        <tbody style="padding: 0px !important">
            <tr>
                <td style="width: 50%">
                    <div style="width: 83.5%; padding: 14px 16px 14px 16px; border-bottom: 1px solid black; border-right: 0px solid black; border-left: 1px solid black">
                        <span class="contentTitle">
                            <b>
                                Destinatario
                            </b>
                            <p style="margin-top: 0px">
                                <span class="contentProduct">
                                    <b style="font-weight: 400">
                                        {{ $order->client ? $order->client->name : '' }}
                                    </b>
                                </span>
                            </p>
                        </span>
                    </div>
                </td>
                <td style="width: 50%">
                    <div style="width: 82%; padding: 14px 16px 14px 16px; border-bottom: 1px solid black; border-right: 1px solid black; border-left: 0px solid black">
                        <span class="contentTitle">
                            <b>
                                Teléfono
                            </b>
                            <p style="margin-top: 0px">
                                <span class="contentProduct">
                                    <b style="font-weight: 400">
                                        {{ $order->client ? $order->client->phone : '' }}
                                    </b>
                                </span>
                            </p>
                        </span>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
    <table class="table" style="padding: 0 !important; margin-top: -3px">
        <tbody style="padding: 0px !important">
            <tr>
                <td>
                    <div style="width: 90.8%; height: 40px; padding: 14px 16px 14px 16px; border-bottom: 1px solid black; border-right: 1px solid black; border-left: 1px solid black">
                        <span class="contentTitle">
                            <b>
                                Observaciones
                            </b>
                            <p style="margin-top: 0px; text-align: justify">
                                <span class="contentProduct">
                                    <b style="font-weight: 400">
                                        {{ Str::substr($order->observation, 0, 250) }}.
                                        @if (Str::length($order->observation) > 250)
                                            ..
                                        @endif
                                    </b>
                                </span>
                            </p>
                        </span>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
    <table class="table" style="padding: 0 !important; margin-top: -5px">
        <tbody style="padding: 0px !important">
            <tr>
                <td>
                    <div style="width: 90.8%; height: 40px; padding: 14px 16px 14px 16px; border-bottom: 1px solid black; border-right: 1px solid black; border-left: 1px solid black">
                        <div style="margin-top: -0px">
                            {!! DNS1D::getBarcodeHTML($order->reference, 'C39', 1.9, 30) !!}
                        </div>
                            @if (isset($configuration) and !is_null($configuration))
                                <div style="margin-top: -5px">
                                    <center>
                                        <span style="font-size: 10px">
                                            {{ $configuration->guide_footer }}
                                        </span>
                                    </center>
                                </div>
                            @endif
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
</body>
</html>
