<?php
namespace Database\Seeders;

use App\Departament;
use Illuminate\Database\Seeder;

class DepartamentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //
        $countries = [
            'Colombia' => [
                'Amazonas',
                'Antioquia',
                'Arauca',
                'Atlántico',
                'Bolívar',
                'Boyacá',
                'Caldas',
                'Caquetá',
                'Casanare',
                'Cauca',
                'Cesar',
                'Chocó',
                'Córdoba',
                'Cundinamarca',
                'Guainía',
                'Guaviare',
                'Huila',
                'La Guajira',
                'Magdalena',
                'Meta',
                'Nariño',
                'Norte de Santander',
                'Putumayo',
                'Quindío',
                'Risaralda',
                'San Andrés y Providencia',
                'Santander',
                'Sucre',
                'Tolima',
                'Valle del Cauca',
                'Vaupés',
                'Vichada',
            ],
            'Venezuela' => [
                'Amazonas',
                'Anzoátegui',
                'Apure',
                'Aragua',
                'Barinas',
                'Bolívar',
                'Carabobo',
                'Cojedes',
                'Delta Amacuro',
                'Falcón',
                'Guárico',
                'Lara',
                'Mérida',
                'Miranda',
                'Monagas',
                'Nueva Esparta',
                'Portuguesa',
                'Sucre',
                'Táchira',
                'Trujillo',
                'Vargas',
                'Yaracuy',
                'Zulia',
            ],
            'Panamá' => [
                'Bocas del Toro',
                'Coclé',
                'Colón',
                'Chiriquí',
                'Darién',
                'Herrera',
                'Los Santos',
                'Panamá',
                'Veraguas',
                'Comarca Guna Yala',
                'Comarca Ngäbe-Buglé',
            ],
        ];

        // Itera sobre los países y sus estados y guarda los datos en la base de datos
        foreach ($countries as $countryName => $states) {
            foreach ($states as $stateName) {
                $departament = Departament::where('name', $stateName)->first();
                if ($departament) {
                    $departament->update(['country' => $countryName]);
                } else {
                    Departament::create([
                        'name' => $stateName,
                        'country' => $countryName,
                    ]);
                }
            }
        }
    }
}
