<?php

namespace App\Services\Onexfy\StatusHandlers;

use App\Services\Domicilio\DomicilioSettlementService;
use App\Enums\DomicilioStatusConst;

class StatusHandlerFactory
{
    protected $domicilioSettlementService;

    public function __construct(DomicilioSettlementService $domicilioSettlementService)
    {
        $this->domicilioSettlementService = $domicilioSettlementService;
    }

    public function getHandler(string $status): StatusHandlerInterface
    {
        switch ($status) {
            case DomicilioStatusConst::VERIFIED:
                return new VerifiedStatusHandler($this->domicilioSettlementService);
            case DomicilioStatusConst::RETURNED:
                return new ReturnedStatusHandler();
            default:
                return new DefaultStatusHandler();
        }
    }
}
