<?php

namespace App\Services\External;

use App\Domicilio;
use App\DomicilioNews;
use App\Evidence;
use App\Enums\DomicilioStatusConst;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\Exception\BadRequestException;
use App\Http\Resources\External\DomiciliosNewResource;

class ExternalService
{
    public function getDomiciliosNews($reference)
    {
        $domicilio = Domicilio::where('reference', $reference)->get()->first();

        if (!$domicilio) {
            throw new NotFoundHttpException('Domicilio no encontrado');
        }

        if ($domicilio->status !== DomicilioStatusConst::NEW_EVENT) {
            throw new BadRequestException("El domicilio no esta en estado novedad");
        }

        $domiciliosNews = DomicilioNews::with('type')->where('domicilio_id', $domicilio->id)->get();
        $evidences = Evidence::where('domicilio_id', $domicilio->id)->get();

        $domiciliosNews = DomiciliosNewResource::collection($domiciliosNews);

        return [
            'news' => DomiciliosNewResource::collection($domiciliosNews),
            'evidences' => $evidences
        ];
    }
}
