<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Permission extends Model
{
    // fillable
    protected $fillable = ['name', 'slug', 'description'];

    /**
     * The roles that belong to the RolePermission
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function Roles()
    {
        return $this->belongsToMany(Permission::class, 'role_permissions', 'permission_id', 'role_id');
    }
}
