<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Traits\ConsumeExternalService;
use Illuminate\Http\Request;

class CitiesPropagation implements ShouldQueue
{
    use ConsumeExternalService;

    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    private $request, $baseUrl, $city;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($city, Request $request)
    {
        //
        $this->request = $request;
        $this->baseUrl = config('services.onexfy.api_url');
        $this->city = $city;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
        try {
            $params = [
                'id' => $this->city->id,
                'city' => $this->city->name,
                'department' => $this->city->Departament ? $this->city->Departament->name : '',
            ];
            $guideRequest = json_decode($this->performanceRequest(
                $this->request,
                'POST',
                "api/OnexDelivery/update-cities",
                $params
            ));
        } catch (\Exception $e) {
            \Log::error($e->getMessage());
        }
    }
}
