<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Ecommerce\EcommerceResource;
use App\Domiciliario;

class UserResource extends JsonResource
{
    private function getDomiciliario(int $domiciliarioId)
    {
        $domiciliario = Domiciliario::find($domiciliarioId);

        if (!isset($domiciliario)) {
            throw new \Exception("No se encuentra el domiciliario de id $domiciliarioId");
        }

        return $domiciliario;
    }

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'photo' => $this->photo,
            'type' => $this->type,
            'role_id' => $this->role_id,
            'domiciliario_id' => $this->domiciliario_id,
            'woocomerce_url'  => $this->woocomerce_url,
            'woocomerce_ck'  => $this->woocomerce_ck,
            'woocomerce_cs'  => $this->woocomerce_cs,
            'has_woocommerce' => $this->has_woocommerce ? true : false,
            'ecommerceConfig' => $this->EcommerceConfigs,
            'ownUser' =>  $this->getOwnUser($this->parent_id),
            'brand'  => new EcommerceResource($this->Ecommerce),
            'storage_id'  => $this->storage_id,
            'storage'  => $this->Storage,
            'city'  => $this->city,
            'address'  => $this->address,
            'phone'  => $this->phone,
            'dni'  => $this->dni,
            'last_name'  => $this->last_name,
            'log_sender_id'  => $this->log_sender_id,
            'domiciliario_data' => $this->type === 3 ? $this->getDomiciliario($this->domiciliario_id) : [],
            'sender_data' => $this->type === 4 ? \App\LogSender::find($this->log_sender_id) : [],
            'scopes' => $this->Role ? $this->Role->Permissions : []
        ];
    }
}
