<?php

namespace App\Http\Resources\Resolution;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\ResolutionInvoice\ResolutionInvoiceCollection;

class ResolutionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'date_from' => $this->date_from,
            'date_to' => $this->date_to,
            'prefix' => $this->prefix,
            'from' => $this->from,
            'to' => $this->to,
            'resolution' => $this->resolution,
            'resolution_date' => $this->resolution_date,
            'type_resolution' => $this->type_resolution,
            'typeResolution' => $this->getResolutionType(),
            'storage' => $this->Storage,
            'user' => $this->User,
            'counter' => $this->counter,
            'is_general' => $this->is_general ? true: false,
            'is_active' => $this->is_active ? true : false,
            'invoices' => new ResolutionInvoiceCollection($this->ResolutionInvoices)
        ];
    }
}
