<?php

namespace App\Http\Resources\Product;

use Illuminate\Http\Resources\Json\JsonResource;

use App\Http\Resources\Category\CategoryCollection;
use App\Http\Resources\ProductVariants\ProductVariantsCollection;
use App\Http\Resources\Storage\ProductResourceCollection;
use App\InventoryMovements;
use App\Domicilio;
use App\PodOrder;
use App\User;
use App\Http\Resources\Domicilio\ClientResource;
use App\Seller;
use Carbon\Carbon;

class ProductsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $now = Carbon::now();
        $ultima_venta = $this->DomicilioProduct()->whereBetween('created_at', [$now, $now->subDays(10)])->orderBy('id', 'DESC')->first();
        if (!isset($ultima_venta)) {
            $ultima_venta =  $this->PodOrderProduct()->whereBetween('created_at', [$now, $now->subDays(10)])->orderBy('id', 'DESC')->first();
            if (!isset($ultima_venta)) {
                $ultima_venta =  $this->PodOrderProduct()->orderBy('id', 'DESC')->first();
            }
        }

        if ($ultima_venta)
        {
            $last_sale_date = $ultima_venta->created_at->format('d/m/Y');

            $fecha1 = date_create($ultima_venta->created_at);
            $fecha2 = date_create(date('Y-m-d H:i:s'));
            $days_without_selling = date_diff($fecha1, $fecha2)->format('%a');
        }
        else
        {
            $last_sale_date = '-';
            $days_without_selling = '-';
        }

        $last_movements = InventoryMovements::where('product_id', $this->id)->orderBy('id', 'DESC')->limit(6)->get();
        foreach ($last_movements as $key => $value) {
            if ($value->document_type == 'App\Domicilio') {
                $order = Domicilio::find($value->document_id);
                if (!$order) {
                    $order = Domicilio::withTrashed()->where('id', $value->document_id)->first();
                }
                $value->order = isset($order) ? new ClientResource($order) : '';
            }
            if ($value->document_type == 'App\PodOrder') {
                $order = PodOrder::find($value->document_id);
                if (!$order) {
                    $order = PodOrder::withTrashed()->where('id', $value->document_id)->first();
                }
                $value->order = isset($order) ? new ClientResource($order) : '';
            }

            $value->user = isset($order->User) ? $order->User()->get() : '';
        }

        return [
            'id' => $this->id,
            'name' => $this->name,
            'slug' => $this->slug,
            'type' => $this->type,
            'status' => $this->status,
            'description' => $this->description,
            'short_description' => $this->short_description,
            'featured' => $this->featured,
            'sku' => $this->sku,
            'price' => $this->price,
            'prices' => $this->prices,
            'offer_price' => $this->offer_price ? $this->offer_price : 0,
            'value' => $this->utilities,
            'regular_price' => $this->regular_price,
            'sale_price' => $this->sale_price,
            'stock_quantity' => $this->storageQuantity(),
            'stock_status' => $this->stock_status,
            'terms' => $this->Terms,
            'images' => $this->Images,
            'unit_of_measurement' => $this->unit_of_measurement,
            'tax' => $this->tax,
            'attributes' => $this->Attributes,
            'creation_date' => date_create($this->created_at)->format('d/m/Y'),
            'last_sale_date' => $last_sale_date,
            'days_without_selling' => $days_without_selling,
            'last_movements' => $last_movements,
            'categories' => new CategoryCollection($this->Categories),
            'variants' => new ProductVariantsCollection($this->ProductVariants),
            'storages' => new ProductResourceCollection($this->getStorages()),
            'woocomerce_id' => $this->woocomerce_id,
            'discount' => $this->discount
        ];
    }
}
