<?php

namespace App\Http\Resources\PosPayment;

use Illuminate\Http\Resources\Json\ResourceCollection;

class PosPaymentCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            return [
                'id' => $models->id,
                'total' => $models->total,
                'user' => $models->User ? $models->User->name : 'Sin usuario',
                'date' => $models->created_at->format('d-m-Y'),
                'hour' => $models->created_at->format('H:i'),
                'check' => $models->is_check ? 'Si' : 'No'
            ];
        });
    }
}
