<?php

namespace App\Http\Resources\Pod;

use Illuminate\Http\Resources\Json\JsonResource;

use App\Http\Resources\PodProduct\PodProductCollection;
use App\Http\Resources\Client\ClientResource;
use App\Http\Resources\User\UserResource;
use App\Http\Resources\Seller\SellerResource;
use App\Http\Resources\PosPayment\PosPaymentCollection;
use App\PaymentReceived;
use DB;

class PodResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $paymentRec = PaymentReceived::where('creditable_id', $this->id)
        ->with('client')
        ->with('bank')
        ->with('type_payment')
        ->get();

        $resolution = DB::table('resolutions')
        ->leftJoin('resolution_invoices', 'resolution_invoices.resolution_id', 'resolutions.id')
        ->where('resolutions.is_active', true)
        ->where('resolutions.type_resolution', 4)
        ->where('resolution_invoices.invoice', $this->reference)
        ->where('resolutions.user_id', $this->user_id)
        ->whereNull('resolutions.deleted_at')
        ->where('resolutions.storage_id', $this->storage_id)
        ->select(
            'resolutions.id',
            'resolutions.date_from',
            'resolutions.date_to',
            'resolutions.to',
            'resolutions.from',
            'resolutions.resolution',
            'resolutions.prefix',
        )
        ->groupBy('resolutions.id')
        ->first();
        return [
            'id' => $this->id,
            'total' => $this->total,
            'total_payment' => $this->total_payment,
            'utilities'  => $this->utilities,
            'type_payment'  => $this->type_payment,
            'type'  => 3,
            'observation'  => $this->observation,
            'seller_id'  => $this->seller_id,
            'client_id'  => $this->client_id,
            'delivery'  => $this->delivery,
            'user_id'  => $this->user_id,
            'effecty'  => $this->effecty,
            'discount'  => $this->discount,
            'totalDiscount'  => $this->totalDiscount,
            'subtotal'  => $this->subtotal,
            'debit'  => $this->debit,
            'creditT'  => $this->credit,
            'turned'  => $this->turned,
            'transfer'  => $this->transfer,
            'pending' => $this->is_credit ? $this->getPending() : 0,
            'storage'  => $this->Storage,
            'reference'  => $this->reference,
            'invoice_url'  => $this->invoice_url,
            'invoice_number'  => $this->invoice_number,
            'credit'  => $this->is_credit ? 'Si' : 'No',
            'date'  => $this->created_at->format('d-m-Y'),
            'hour'  => $this->created_at->format('H:i'),
            'total_payment'  => $this->pay_total,
            'purse' => ($this->credit - $this->pay_total),
            'is_pos'  => true,
            'products'  => new PodProductCollection($this->Products),
            'client'  => new ClientResource($this->Client),
            'seller'  => new SellerResource($this->Seller),
            'returns' => $this->Returns ? true : false,
            'brand'  => new UserResource($this->User),
            'payments'  => new PosPaymentCollection($this->Payments),
            'creditNotes' => $this->Returns,
            'credit_apply' => $this->credit_apply,
            'user'  => new UserResource($this->User),
            'creditTotal' => $this->totalCredit(),
            'taxt' => $this->taxt,
            'cost_center' => $this->cost_center_id > 0 ? CostCenter::find($this->cost_center_id) : 'Por defecto',
            'tax_total' => $this->tax_total,
            'expiration_date' => $this->expiration_date,
            'subtotalWithOutTax' => $this->getSubtotalWithOutTax(1.19),
            'payment_received' => $paymentRec,
            'hora' => $this->created_at->format('d-m-Y H:s'),
            'remaining' => $this->total - $this->total_payment,
            'resolution' => isset($resolution) ? $resolution  : ""
        ];
    }
}
