<?php

namespace App\Http\Resources\Pod;

use Illuminate\Http\Resources\Json\ResourceCollection;
use App\Http\Resources\PodProduct\PodProductCollection;
use App\Http\Resources\Seller\SellerResource;
use App\Http\Resources\Client\ClientResource;
use DB;

class PodCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            $resolution = DB::table('resolutions')
            ->leftJoin('resolution_invoices', 'resolution_invoices.resolution_id', 'resolutions.id')
            ->where('resolutions.is_active', true)
            ->where('resolutions.type_resolution', 4)
            ->where('resolution_invoices.invoice', $models->reference)
            ->where('resolutions.user_id', $models->user_id)
            ->whereNull('resolutions.deleted_at')
            ->where('resolutions.storage_id', $models->storage_id)
            ->select(
                'resolutions.prefix',
            )
            ->groupBy('resolutions.id')
            ->first();
                return [
                    'id' => $models->id,
                    'reference' =>  $resolution ?  $resolution->prefix . ' '. $models->reference : $models->reference,
                    'price'  => $models->total,
                    'total'  => $models->total,
                    'taxt' => $models->taxt,
                    'tax_total' => $models->tax_total,
                    'client_id' => $models->client_id,
                    'utilities'  => $models->utilities,
                    'discount'  => $models->discount,
                    'invoice_url'  => $models->invoice_url,
                    'invoice_number'  => $models->invoice_number,
                    'delivery'  => $models->delivery,
                    'totalDiscount'  => $models->totalDiscount,
                    'subtotal'  => $models->subtotal,
                    'seller_id'  => new SellerResource($models->Seller),
                    'purse' => ($models->total - $models->total_payment),
                    'is_pay'  => true,
                    'hora'  => $models->created_at->format('d-m-Y H:i:s'),
                    'type'  => 3,
                    'quantity'  => count($models->Products),
                    'status'  => 10,
                    'turned'  => $models->turned,
                    'returns'  => count($models->Returns),
                    'type_payment'  => $models->type_payment,
                    'storage_id'  => $models->storage_id,
                    'storage'  => $models->Storage,
                    'credit'  => $models->is_credit ? 'Si' : 'No',
                    'products'  => new PodProductCollection($models->Products),
                    'name' => $models->Client ? $models->Client->name : 'Sin cliente',
                    'client'  => new ClientResource($models->Client),
                    'expiration_date' => $models->expiration_date ? $models->expiration_date : $models->created_at->format('d-m-Y'),
                    'cost_center_id' => $models->cost_center_id,
                    'remaining' => $models->total - $models->total_payment,
                    'created_at'  => $models->created_at,
                ];
            });
    }
}
