<?php

namespace App\Http\Resources\PhisicalCounting;

use Illuminate\Http\Resources\Json\ResourceCollection;

class ProductsCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            return [
                'id' => $models->id,
                'reference' => $models->product_variant_id ? $models->productVariant->sku : $models->product->sku,
                'name' => $models->product->name,
                'variant' => $models->product_variant_id ?  $models->productVariant->attribute : 'Simple',
                'physical_stock' => $models->physical_stock,
                'system_stock' => $models->system_stock,
                'diference' => $models->diference
            ];
        });
    }
}
