<?php

namespace App\Http\Resources\Domicilio;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class DomicilioDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        // data
        $status = [];
        foreach ($this->statusDomicilio as $key => $state) {
            $state['date'] = $state['created_at']->format('d-m-Y');
            $state['hour'] = $state['created_at']->format('H:i:s');
            array_push($status, $state);
            unset($state['created_at'], $state['updated_at']);
        }

        $news = [];
        foreach ($this->News as $key => $new) {
            $new['date'] = $new['created_at']->format('d-m-Y');
            $new['hour'] = $new['created_at']->format('H:i:s');
            array_push($news, $new);
            unset($new['created_at'], $new['updated_at']);
        }

        // return
        return [
            'status_domicilio' => $status,
            'news' => $news,
        ];
    }
}
