<?php

namespace App\Http\Resources\Domiciliario;

use Illuminate\Http\Resources\Json\ResourceCollection;
use App\User;

class DomiciliarioCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            return [
                'id' => $models->id,
                'name' => $models->name,
                'email' => $models->email, // HERC
                'dni' => $models->dni,
                'phone'  => $models->phone,
                'plate' => $models->placa,
                'photo' => $models->photo,
                'send' => $models->domicilios->count(),
                'hiring_method' => $models->hiring_method
            ];
        });
    }
}
