<?php

namespace App\Http\Requests\Parameters;

use Illuminate\Foundation\Http\FormRequest;

class UpdateParameterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "name" => "sometimes|min:3",
            "type" => "sometimes|min:3",
            "value" => "sometimes",
            "description" => "nullable|max:255"
        ];
    }

    public function messages()
    {
        return [
            "name.min" => "El nombre del parámetro requiere mínimo 3 caracteres",
            "type.min" => "El tipo del parámetro requiere mínimo 3 caracteres",
            "description.max" => "La descripción no puede tener más de 255 caracteres"
        ];
    }
}
