<?php

namespace App\Http\Requests\NewTypes;

use Illuminate\Foundation\Http\FormRequest;

class UpdateNewTypeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "name" => "sometimes|min:10|max:50"
        ];
    }

    public function messages()
    {
        return [
            "name.min" => "El nombre del tipo de novedad es requiere minimo 10 caracteres",
            "name.max" => "El nombre del tipo de novedad no puede tener mas de 50 caracteres"
        ];
    }
}
