<?php

namespace App\Http\Requests\DispatchRelation;

use Illuminate\Foundation\Http\FormRequest;

class AddOrderDispatchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "reference" => "required|exists:domicilios,reference",
            "relation_id" => "required|exists:dispatch_relations,id"
        ];
    }

    public function messages()
    {
        return [
            "reference.required" => "El numero de guia es requerido",
            "reference.exists" => "No existe una orden con esa referencia",
            "relation_id.required" => "El id de la relacion de despacho es requerido",
            "relation_id.exists" => "No existe la relacion de despacho que quieres modificar"
        ];
    }
}
