<?php

namespace App\Http\Requests\City;

use Illuminate\Foundation\Http\FormRequest;

class CityRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = $this->id ?? '';
        return [
            //
            'name' => 'required|max:255|unique:cities,name,' . $id,
            'abbreviation' => 'required|max:3|unique:cities,abbreviation,' . $id,
            'departament_id' => 'required|exists:departaments,id',
            'country' => 'required'
        ];
    }

    public function messages() {
        return [
            'name.required' => 'El nombre de la ciudad es requerido.',
            'name.unique' => 'El nombre de la ciudad se encuentra en uso.',
            'name.max' => 'El nombre de la ciudad debe tener maximo 90 caracteres.',
            'abbreviation.required' => 'La abreviación de la ciudad es requerido.',
            'abbreviation.unique' => 'La abreviación de la ciudad se encuentra en uso.',
            'abbreviation.max' => 'La abreviaciónde la ciudad debe tener maximo 3 caracteres.',
            'departament_id.required' => 'El departamento de la ciudad es requerido.',
            'departament_id.exists' => 'El departamento de la ciudad debe existir en nuestros registros.',
        ];
    }
}
