<?php

namespace App\Http\Middleware;
use App\Traits\ApiResponser;

use Closure;

class IsActiveUser
{
    use ApiResponser;
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (!$request->user()->is_active)
            return $this->errorResponse('Tu usuario se encuentra inactivo en nuestro sistema, por favor comunicate con nosotros.', 401);
        return $next($request);
    }
}
