<?php

namespace App\Http\Controllers;

use App\Domicilio;
use App\PodOrder;
use Illuminate\Http\Request;
use App\User;
use App\Storage;
use App\Seller;
use App\Product;
use PDF;
use App\Traits\ApiResponser;
use App\Services\User\UserServices;
use App\Http\Resources\Domicilio\DomicilioResource;
use Luecano\NumeroALetras\NumeroALetras;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use App\PaymentReceived;
use Illuminate\Support\Str;

class ReportPdfController extends Controller
{
    use ApiResponser;
    //ventas diarias
    public function pdfDiary(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());

            //get user data
            $userData = User::findOrFail($mainId);
            $data['user'] = $userData;


            $pdf = PDF::loadView('report.sellers.diary', array('data' => $data));

            //set path
            $path = public_path('reports/sellers/');
            //set name
            if ($request->has('user') and $request->user['type'] === 2) {
                $fileName =  'seller_diary_'. $request->user['brand']['brand_name'] . '.' . 'pdf' ;
            } else {
                $fileName =  'seller_diary_'. $request->user['ownUser']['brand']['brand_name'] . '.' . 'pdf' ;
            }
            //save
            $pdf->save($path . '/' . $fileName);

            $file = url("/reports/sellers/" . $fileName);

            return response()->json(['url' => $file]);

        } catch (\Exception $e) {
            return response()->json(['errors'=>array(['code' => 422, 'message' => $e->getMessage()])], 422);
        }
    }

    //ventas por item
    public function pdfItemsSeller(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());

            //get user data
            $userData = User::findOrFail($mainId);
            $data['user'] = $userData;
            if (!isset($data['product'])) {
                $data['product']['name']= 'Todos los Productos';
            }
            $pdf = PDF::loadView('report.items.seller', array('data' => $data));

            //set path
            $path = public_path('reports/items/');
            //set name
            $fileName =  'seller_items_'. $userData->Ecommerce->brand_name .'.pdf' ;
            //save
            $pdf->save($path . '/' . $fileName);

            $file =url("/reports/items/" . $fileName);

            return response()->json(['url' => $file]);
        } catch (\Exception $e) {
            return response()->json(['errors'=>array(['code' => 422, 'message' => $e->getMessage()])], 422);
        }
    }

    // client seller pdf
    public function pdfClientsSeller(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());

            //get user data
            $userData = User::findOrFail($mainId);
            $data['user'] = $userData;
            if (!isset($data['client'])) {
                $data['client']['name']= 'De todos los Clientes';
            }
            $pdf = PDF::loadView('report.clients.seller', array('data' => $data));

            //set path
            $path = public_path('reports/clients/');
            //set name
            $fileName =  'seller_client_'. $userData->Ecommerce->brand_name . '.' . 'pdf' ;

            //save
            $pdf->save($path . '/' . $fileName);

            $file =url("/reports/clients/" . $fileName);

            return response()->json(['url' => $file]);

        } catch (\Exception $e) {
            return response()->json(['errors'=>array(['code' => 422, 'message' => $e->getMessage()])], 422);
        }
    }

    //rentabildiad por item
    public function pdfItemRent(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());

            //get user data
            $userData = User::findOrFail($mainId);
            $data['user'] = $userData;
            if (!isset($data['product'])) {
                $data['product']['name']= 'Todos los Productos';
            }

            $pdf = PDF::loadView('report.items.rent', array('data' => $data));

            //set path
            $path = public_path('reports/items/');
            //set name
            $fileName =  'rent_item_'. $userData->Ecommerce->brand_name . '.' . 'pdf' ;

            //save
            $pdf->save($path . '/' . $fileName);

            $file =url("/reports/items/" . $fileName);

            return response()->json(['url' => $file]);

        } catch (\Exception $e) {
            return response()->json(['errors'=>array(['code' => 422, 'message' => $e->getMessage()])], 422);
        }
    }

    // SELLERS seller pdf
    public function pdfSellerSellers(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());

            //get user data
            $userData = User::findOrFail($mainId);
            $data['user'] = $userData;
            if (!isset($data['seller'])) {
                $data['seller']['name']= 'Todos las Ventas por vendedor';
            }
            $pdf = PDF::loadView('report.sellers.sellers', array('data' => $data));

            //set path
            $path = public_path('reports/sellers/');
            //set name
            $fileName =  'seller_sellers_'. $userData->Ecommerce->brand_name . '.' . 'pdf' ;

            //save
            $pdf->save($path . '/' . $fileName);

            $file =url("/reports/sellers/" . $fileName);

            return response()->json(['url' => $file]);

        } catch (\Exception $e) {
            return response()->json(['errors'=>array(['code' => 422, 'message' => $e->getMessage()])], 422);
        }
    }
    //Estado de Cuentas Cliente  pdf
    public function pdfEstateClients(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());

            //get user data
            $userData = User::findOrFail($mainId);
            $data['user'] = $userData;
            if (!isset($data['seller'])) {
                $data['client']['name']= 'Todos las Ventas por vendedor';
            }
            $pdf = PDF::loadView('report.clients.estates', array('data' => $data));

            //set path
            $path = public_path('reports/clients/');
            //set name
            $fileName =  'seller_clients_estates'. $userData->Ecommerce->brand_name . '.' . 'pdf' ;

            //save
            $pdf->save($path . '/' . $fileName);

            $file =url("/reports/clients/" . $fileName);

            return response()->json(['url' => $file]);
        } catch (\Exception $e) {
            return response()->json(['errors'=>array(['code' => 422, 'message' => $e->getMessage()])], 422);
        }
    }
    // Cuentas por Cobrar  pdf
    public function pdfReceivable(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());

            //get user data
            $userData = User::findOrFail($mainId);
            $data['user'] = $userData;
            if (!isset($data['seller'])) {
                $data['seller']['name']= 'Todos las Ventas por vendedor';
            }
            $pdf = PDF::loadView('report.receivable.cobrar', array('data' => $data));

            //set path
            $path = public_path('reports/receivable/');
            //set name
            $fileName =  'seller_receivable'. $userData->Ecommerce->brand_name . '.' . 'pdf' ;

            //save
            $pdf->save($path . '/' . $fileName);

            $file =url("/reports/receivable/" . $fileName);
            return response()->json(['url' => $file]);

        } catch (\Exception $e) {
            return response()->json(['errors'=>array(['code' => 422, 'message' => $e->getMessage()])], 422);
        }
    }
    // Valor de inventario pdf
    public function pdfInventory(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());

            //get user data
            $userData = User::findOrFail($mainId);
            $data['user'] = $userData;
            $pdf = PDF::loadView('report.inventory.value', array('data' => $data));

            //set path
            $path = public_path('reports/inventory/');
            //set name
            $fileName =  'seller_inventory_value'. $userData->Ecommerce->brand_name . '.' . 'pdf' ;

            //save
            $pdf->save($path . '/' . $fileName);

            $file =url("/reports/inventory/" . $fileName);
            return response()->json(['url' => $file]);
        } catch (\Exception $e) {
            return response()->json(['errors'=>array(['code' => 422, 'message' => $e->getMessage()])], 422);
        }
    }
    // Ventas por categorias pdf
    public function pdfCategory(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());

            //get user data
            $userData = User::findOrFail($mainId);
            $data['user'] = $userData;
            if (!isset($data['seller'])) {
                $data['seller']['name']= 'Todos las Ventas por vendedor';
            }
            foreach ($data['lista'] as $i=> $dato) {
                foreach ($dato['product']['prices'] as $precio) {
                    if($precio['order'] == 1){
                        $data['lista'][$i]['price1'] = $precio['price'];
                    }elseif ($precio['order'] == 2) {
                        $data['lista'][$i]['price2'] = $precio['price'];
                    }elseif ($precio['order'] == 3) {
                        $data['lista'][$i]['price3'] = $precio['price'];
                    }
                }
            }
            $pdf = PDF::loadView('report.category.sellers', array('data' => $data));

            //set path
            $path = public_path('reports/category/');
            //set name
            $fileName =  'seller_category_'. $userData->Ecommerce->brand_name . '.' . 'pdf' ;

            //save
            $pdf->save($path . '/' . $fileName);

            $file =url("/reports/category/" . $fileName);

            return response()->json(['url' => $file]);

        } catch (\Exception $e) {
            return response()->json(['errors'=>array(['code' => 422, 'message' => $e->getMessage()])], 422);
        }
    }
    // Ventas por bodegas pdf
    public function pdfWerehouse(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());

            //get user data
            $userData = User::findOrFail($mainId);
            $data['user'] = $userData;
            $pdf = PDF::loadView('report.werehouse.sellers', array('data' => $data));

            //set path
            $path = public_path('reports/werehouse/');
            //set name
            $fileName =  'seller_werehouse_'. $userData->Ecommerce->brand_name . '.' . 'pdf' ;

            //save
            $pdf->save($path . '/' . $fileName);

            $file =url("/reports/werehouse/" . $fileName);

            return response()->json(['url' => $file]);

        } catch (\Exception $e) {
            return response()->json(['errors'=>array(['code' => 422, 'message' => $e->getMessage()])], 422);
        } catch (\Exception $e) {
            return response()->json(['errors'=>array(['code' => 422, 'message' => $e->getMessage()])], 422);
        }

    }
    // Lista de precios pdf
    public function pdfListPrices(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());
            //get user data
            $userData = User::findOrFail($mainId);
            $data['user'] = $userData;
            if ($request->product)
                $data['product'] = Product::findOrFail($request->product);
            // configuramos el pdf
            $pdf = PDF::loadView('report.sellers.prices', array('data' => $data));
            //set path
            $path = public_path('reports/sellers/');
            //set name
            $fileName =  'seller_by_price_'. $userData->Ecommerce->brand_name . '.' . 'pdf' ;
            //save
            $pdf->save($path . '/' . $fileName);
            $file =url("/reports/sellers/" . $fileName);
            return $this->successResponse(['url' => $file]);
        } catch (\Exception $e) {
            return $this->errorUnprocessableEntityResponse($e->getMessage());
        }
    }
    // Movimientos por inventarios pdf
    public function pdfMovimentsInventory(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());
            //get user data
            $userData = User::findOrFail($mainId);
            $path = public_path('reports/movement/');
            $data['user'] = $userData;
            if (isset($request->product))
                $data['product'] = Product::findOrFail($request->product);
            $fileName =  'movement_items_'. $userData->Ecommerce->brand_name .'.pdf' ;
            $pdf = PDF::loadView('report.movement.list', array('data' => $data));
            $pdf->save($path . '/' . $fileName);
            $file =url("/reports/movement/" . $fileName);
            return $this->successResponse(['url' => $file]);
        } catch (\Exception $e) {
            return $this->errorUnprocessableEntityResponse($e->getMessage());
        }
    }

    /**
     *
     * utilidades por vendedor
     */
    public function pdfUtilitySeller(Request $request) {
        try {
            $data = $request->all();
            //main id user
            $mainId = $request->user()->getIdMain($request->user());
            //get user data
            $userData = User::findOrFail($mainId);
            $path = public_path('reports/sellers/');
            $data['user'] = $userData;
            if (isset($request->seller))
                $data['seller'] = Seller::findOrFail($request->seller);
            $fileName =  'utilidades_vendedor_'. $userData->Ecommerce->brand_name .'.pdf' ;
            $pdf = PDF::loadView('report.sellers.utilities_seller', array('data' => $data));
            $pdf->save($path . '/' . $fileName);
            $file =url("/reports/sellers/" . $fileName);
            return $this->successResponse(['url' => $file]);
        } catch (\Exception $e) {
            return $this->errorUnprocessableEntityResponse($e->getMessage());
        }
    }

    public function generateInvoice(Request $request)
    {
        try {
            $mainId = $request->user()->getIdMain($request->user());
            $formatter = new NumeroALetras();
            if($request->model == 'domicilio')
            {
                $domicilio = Domicilio::findOrFail($request->id);
                $userData = User::findOrFail($mainId);
                $domicilio = Domicilio::findOrFail($request->id);
                $domicilio->brand = $userData->Ecommerce;
                $domicilio->letterTotal = Str::ucfirst($formatter->toWords($domicilio->total, 2));
                $domicilio->qr = QrCode::format('svg')->size(399)->color(40,40,40)->generate($domicilio->reference);
                $file = $this->generatePdfInvoice($request->type_page, new DomicilioResource($domicilio), $request->id);
            }
            if($request->model == 'pod')
            {
                $pod = PodOrder::findOrFail($request->id);
                $pod->totalWithOutIVA = $pod->getSubtotalWithOutTax();
                $pod->products = $pod->Products;
                $pod->letterTotal = Str::ucfirst($formatter->toWords($pod->total, 2));
                $pod->qr = QrCode::format('svg')->size(399)->color(40, 40, 40)->generate($pod->reference);
                $file = $this->generatePdfInvoice($request->type_page, $pod, $request->id);
            }
            return $this->successResponse($file);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    public function generatePdfInvoice($typePage, $data, $id)
    {
        try {
            $userService = new UserServices();
            // validate data user
            //$userService->valdiateUserData($data->User);
            // get payment data
            $paymentReceiveds = PaymentReceived::where('creditable_id', $data->id)
			->with('type_payment')
			->get()
			->pluck('type_payment.name')
			->toArray();
            $data->paymentOrder = join(" - ", $paymentReceiveds);
            switch (strtolower($typePage)) {
                case 'a4':
                    //generate pdf
                    $pdf = PDF::loadView('pdf/factura', array('order' => $data));
                    $path = public_path('pdf/');
                    $fileName =  'factura_' . $data->reference . '.' . 'pdf';
                    $pdf->save($path . '/' . $fileName);
                    $file = public_path() . $fileName;
                    return url('pdf', $fileName);
                    break;

                case 'pos':
                    if (count($data->products) === 1) {
                        $height = 515.00;
                    }
                    if (count($data->products) === 2) {
                        $height = 550.00;
                    }
                    if (count($data->products) === 3) {
                        $height = 605.00;
                    }
                    if (count($data->products) === 4) {
                        $height = 760.00;
                    }
                    if (count($data->products) === 5) {
                        $height = 810.00;
                    }
                    if (count($data->products) === 6) {
                        $height = 865.00;
                    }
                    if (count($data->products) === 7) {
                        $height = 910.00;
                    }
                    if (count($data->products) === 8) {
                        $height = 970.00;
                    }
                    if (count($data->products) === 9) {
                        $height = 105.00;
                    }
                    if (count($data->products) === 10) {
                        $height = 1050.00;
                    }
                    if (count($data->products) === 11) {
                        $height = 1105.00;
                    }
                    if (count($data->products) === 12) {
                        $height = 1160.00;
                    }
                    if (count($data->products) === 13) {
                        $height = 1210.00;
                    }
                    if (count($data->products) === 14) {
                        $height = 1270.00;
                    }
                    $customPaper = array(0, 0, $height, 240.80);
                    $pdf = PDF::loadView('pdf/invoiceTicket', array('data' => $data))->setPaper($customPaper, 'landscape');
                    $path = public_path('ticket/');
                    $fileName =  'ticket_'. $data->reference . '.' . 'pdf' ;
                    $pdf->save($path . '/' . $fileName);
                    $file = url('ticket', $fileName);
                    return $file;
                    break;
            }
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }
}
