<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\ApiResponser;
use App\Services\General\GeneralServices;

class GeneralController extends Controller
{
    use ApiResponser;

    private $service;

    /**
     * constructor
     */
    public function __construct() {
        $this->service= new GeneralServices();
    }

    /**
     * List departaments
     */
    public function getDepartaments() {
        try {
            return [
                'success' => true,
                'data' => $this->service->getDepartaments()
            ];
        } catch (\Exception $e) {
            return $this->handlerEception($e->getMessage());
        }
    }
}
