<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::middleware('auth:api')->get('v2/getLastOrdersApk', 'DomicilioController@getLastOrdersApk');

Route::middleware('auth:api')->get('v2/getLastOrdersAll', 'DomicilioController@getLastOrdersAll');


//api version 2
Route::group(['prefix' => 'v2'], function () {
    // download excel
    Route::get('/download/excel', 'DomicilioController@exportExcel');
    Route::get('/download/cities/excel', 'CityController@exportExcel');
    Route::get('/download/zones/excel', 'ZoneController@exportExcel');

    // auth routes with out api middleware
    Route::post('login', 'AuthController@login');
    Route::post('recovery', 'AuthController@recovery');
    Route::post('change/password', 'AuthController@changePasswordForToken');
    Route::get('cities/list', 'CityController@listCities');
    Route::get('/domicilio/public/reference/{id}', 'DomicilioController@getByReference');
    Route::get('/domicilio-news/domicilio/{id}', 'DomicilioNewsController@getDomiciliosNewByDomicilio');
    Route::get('report/daily', 'ReportController@statsReportDaily');

    // orders api external
    Route::group(['middleware' => 'dropiService'], function () {
        Route::post('order/create', 'DomicilioController@createOrder'); // create order
        Route::get('list/payments', 'PaymentController@index'); // get payment methods
        Route::get('list/cities', 'CityController@listCities'); // List cities
        Route::get('list/zones', 'ZoneController@listZonesByCity'); // List zones
        Route::get('print/sticker', 'DomicilioController@generateGuide'); // generate sticker
        Route::delete('order/cancel/{reference}', 'DomicilioController@cancelOrder');  // cancela una orden generada
        Route::get('order/details/{reference}', 'DomicilioController@showOrderDetails'); // get order data.
        Route::post('order/solve/{reference}', 'DomiciliosReschedulingController@solvingOrder');
        Route::get('external/domicilio-news/{reference}', 'ExternalFunctionsController@getDomiciliosNews');
    });

    Route::group(['middleware' => ['auth:api', 'isActive']], function () {
        // auth
        Route::post('logout', 'AuthController@logout');
        // clients
        Route::resource('client', 'ClientController');

        // new types
        Route::resource('new-types', 'NewTypeController');
        Route::get('new-types-list', 'NewTypeController@getAllList');

        //payment-methods
        Route::apiResource('payment-methods', 'PaymentMethodController');
        Route::apiResource('parameters', 'ParameterController');
        Route::get("clients/list-dropdown", "ClientController@getListClient");
        Route::get('clients-by-dni/{dni}', 'ClientController@filter');
        Route::get('clients-by-user/{user_id}', 'ClientController@clientsByUserId');
        //payment request
        Route::get('load-payment', 'PaymentController@index');
        // Raul
        Route::get('domiciliario/search', 'DomiciliarioController@search');
        Route::resource('domiciliario', 'DomiciliarioController');
        //auditorias routes
        Route::resource('auditorias', 'AuditController');
        //domicilios ->middleware("plan")
        Route::resource('domicilio', 'DomicilioController');
        Route::post('/domicilio/update', 'DomicilioController@update');
        Route::post('domicilio/update-domiciliary', 'DomicilioController@updateDomiciliary');

        Route::post('domicilio/assign-domiciliary', 'AsignarController@assignDomiciliary');
        Route::post('domicilio/assign-domiciliaryApk', 'AsignarController@assignDomiciliaryApk');


        Route::delete("evidences/{evidence}", "EvidenceController@destroy");


        Route::get('/domicilios/filter', 'DomicilioController@orderTimeInterval');
        Route::post('/domicilio/factura', 'DomicilioController@generatePdf');
        Route::post('/domicilios/status-paid', 'DomicilioController@changeStatusPaid');
        Route::post('/domicilio/delete', 'DomicilioController@destroy');
        Route::get('/domicilioget', 'DomicilioController@getAll');
        Route::get('/domicilioget/{id}', 'DomicilioController@getOne');
        Route::post('/bulk-status/domicilios', 'DomicilioController@changeStatusInbulk');
        Route::post('/domicilio/filter-date', 'DomicilioController@filterDateRange');
        Route::get('/domicilio-history/getAll', 'DomicilioController@getHistory');
        Route::get('/domicilio/reference/{id}', 'DomicilioController@getByReference')->name('domicilio.reference');
        Route::get('/getLastOrders', 'DomicilioController@getLastOrders');
        Route::get('/domicilio-search', 'DomicilioController@findOrder');
        Route::get('/domicilio/domiciliario/{domiciliario_id}', 'DomicilioController@findOrdersByDomiciliario');
        Route::get('generate/guides', 'DomicilioController@generateGuide');
        Route::post('generate/guides-check', 'DomicilioController@generateGuideCheck');
        Route::post('domicilio/from/excel', 'DomicilioController@importFromExcel');

        //lista de domicilios liquidados
        Route::get("settlements", "SettlementDomiciliosController@index");
        Route::get("settlements/{id}", "SettlementDomiciliosController@show");
        //liquidar array de domicilio
        Route::post("settlements/add-domicilio-to-settlement", "SettlementDomiciliosController@addDomicilioToSettlement");
        Route::post("settlements", "SettlementDomiciliosController@makeSettlementDomicilios");
        Route::post("settlements/pdf", "SettlementDomiciliosController@viewPDF");
        Route::delete("settlements/{id}", "SettlementDomiciliosController@destroy");
        Route::delete("settlements/domicilio/{id}", "SettlementDomiciliosController@deleteDomicilioInSettlement");

        //estados
        Route::resource('status', 'StatusController');
        Route::post("status/verify-domicilios", "StatusController@massiveVerify");
        //liquidar
        Route::post('/domicilio/liquidar', 'DomicilioController@liquidarPdf');
        // reports
        Route::get('report/global', 'ReportController@globalReport');
        Route::get('report/month', 'ReportController@statsReportMonth');
        Route::get('report/novelties-and-rescheduled', 'ReportController@noveltiesAndRescheduledReport');
        Route::get('report/products', 'ReportController@productsReport');
        // logistica-remitentes
        Route::get('logistica-remitente', 'LogisticaRemitenteController@index');
        Route::get('logistica-remitente/{id}', 'LogisticaRemitenteController@show');
        Route::post('logistica-remitente', 'LogisticaRemitenteController@store');
        Route::put('logistica-remitente/{id}', 'LogisticaRemitenteController@update');
        Route::delete('logistica-remitente/{id}', 'LogisticaRemitenteController@destroy');
        Route::get('remitentes-for-select', 'LogisticaRemitenteController@getForSelect');
        // Ciudad
        Route::get('city', 'CityController@index');
        // -------------------------------------------------------------------------
        // main routes //-----------------------------------------------------------
        Route::get('main/data', 'MainController@loadMainData');
        // relation dispatch
        Route::resource('dispatchRelation', 'DispatchRelationController');
        Route::get('genearet-relation-pdf', 'DispatchRelationController@emitPdf');
        Route::post('generate-relation-close-pdf', 'DispatchRelationController@generateRelationClose');
        Route::post('dispatchRelation/add-order', 'DispatchRelationController@addOrderInDispatchRelationship');
        Route::get('relation/today', 'DispatchRelationController@getTodayRelation');
        Route::get('/relation/list/domiciliario', 'DispatchRelationController@listByDomiciliario');
        Route::get('orders/by/domiciliario', 'DispatchRelationController@loadOrderByRelationOrNot');
        Route::get('orders/show/{id}', 'DispatchRelationController@getOrderById');
        Route::get('orders/reference/{id}', 'DispatchRelationController@getOrderByReference');
        Route::get('relation/complete/{id}', 'DispatchRelationController@completeRelation');
        Route::get('orders/domiciliario/status', 'DispatchRelationController@getOrdersByStatusTab');
        Route::delete("dispatchRelation/delete-order/{id}", "DispatchRelationController@deleteOrderInDispatchRelationship");
        // domicilio collection
        Route::resource('domicilioCollection', 'DomicilioCollectionController');
        // domicilio news
        Route::resource('domicilioNews', 'DomicilioNewsController');
        // evidence
        Route::post('comprobant-upload', 'DomicilioController@uploadEvidence');
        // cities
        Route::resource('city', 'CityController');
        // zones
        Route::resource('zone', 'ZoneController');
        // senders
        Route::resource('sender', 'LogisticaRemitenteController');
        Route::get('forSelect/sender', 'LogisticaRemitenteController@getForSelect');
        // users
        Route::resource('user', 'UserController');

        //rescheduling
        Route::get("rescheduling", "DomiciliosReschedulingController@index");
        Route::post("rescheduling", "DomiciliosReschedulingController@store");
        /**
         * general routes
         */
        Route::group(['prefix' => 'general'], function () {
            Route::get('departaments', 'GeneralController@getDepartaments');
            Route::get('roles', 'UserController@listRoles');
            Route::resource('configuration', 'ConfigurationController');
        });
    });
    // configuration with out auth
    Route::get('configuration', 'ConfigurationController@index');
    Route::get('parameters', 'ParameterController@index');
});
