<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLogsRelationClosesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('logs_relation_closes', function (Blueprint $table) {
            $table->id();


            $table->unsignedBigInteger('dispatch_relation_id')->nullable();
            $table->foreign('dispatch_relation_id')
                ->references('id')
                ->on('dispatch_relations')
                ->nullOnDelete();

            $table->unsignedBigInteger('domicilio_id')->nullable();
            $table->foreign('domicilio_id')
                ->references('id')
                ->on('domicilios')
                ->nullOnDelete();

            $table->string("log");

            $table->string("last_status");

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('logs_relation_closes');
    }
}
