<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDomiciliosReschedulingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('domicilios_reschedulings', function (Blueprint $table) {
            $table->id();
            $table->foreignId("domicilio_id")
                  ->references("id")
                  ->on("domicilios")
                  ->onUpdate("cascade")
                  ->onDelete("cascade");
            $table->date("rescheduling_date")->nullable();
            $table->string("rescheduling_start_hour")->nullable();
            $table->string("rescheduling_end_hour")->nullable();
            $table->foreignId("modified_by")
                   ->nullable()
                   ->references("id")
                   ->on("users")
                    ->onUpdate("cascade")
                   ->nullOnDelete();
            $table->text("description")->nullable();
            $table->foreignId("evidence_id")
                    ->nullable()
                    ->references("id")
                    ->on("evidence");
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('domicilios_reschedulings');
    }
}
