<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\User;

class Settlement extends Model
{
    use SoftDeletes;

    protected $fillable = [
        "pdf_url",
        "created_by",
        "modified_by",
        "is_open"
    ];

    public function domicilios()
    {
        return $this->belongsToMany(
            Domicilio::class,
            'domicilio_has_settlements',
            'settlement_id',
            'domicilio_id'
        );
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, "created_by");
    }

    public function getSettlementNumberAttribute()
    {
        return "Liquidacion #{$this->id}";
    }
}
