<?php

namespace App\Services\Onexfy\StatusHandlers;

use App\Services\Domicilio\DomicilioSettlementService;
use App\Services\Onexfy\StatusHandlers\StatusUpdateDTO;

class VerifiedStatusHandler implements StatusHandlerInterface
{
    protected $domicilioSettlementService;

    public function __construct(DomicilioSettlementService $domicilioSettlementService)
    {
        $this->domicilioSettlementService = $domicilioSettlementService;
    }

    public function handle(StatusUpdateDTO $request): array
    {
        $settlementData = $this->domicilioSettlementService->calculateSettlementByDomicilio($request->reference);

        if (!is_object($settlementData)) {
            return $this->defaultParams($request);
        }

        if (!$this->domicilioSettlementService->isThereDropshipper($request->reference)) {
            $settlementData->provider_settlement = number_format($settlementData->total, 2);
        }

        $result = $request->toArray();
        $result["dropshipper_settlement"] = $settlementData->dropshipper_settlement ?? 0;
        $result["prov_settlement"] = $settlementData->provider_settlement ? number_format($settlementData->provider_settlement, 2) : 0;

        return $result;
    }

    private function defaultParams(StatusUpdateDTO $request): array
    {
        $result = $request->toArray();
        $result["dropshipper_settlement"] = 0;
        $result["prov_settlement"] = 0;

        return $result;
    }
}
