<?php

namespace App\Services\NewTypes;

use App\NewType;
use App\Http\Resources\NewTypes\NewTypeResource;

class NewTypesService
{
    public function getAllNewTypes()
    {
        return NewTypeResource::collection(NewType::all());
    }

    public function getAllNewTypesPaginated(int $perPage, string $search)
    {
        $query = NewType::query()
            ->when($search, function ($query) use ($search) {
                $query->where(function ($q) use ($search) {
                    $q->where("id", "like", "%{$search}%")
                        ->orWhere("name", "like", "%{$search}%");
                });
            })
            ->orderBy('created_at', 'ASC')
            ->paginate($perPage);

        return NewTypeResource::collection($query)->response()->getData(true);
    }

    public function create($name)
    {
        return NewType::create(["name" => $name]);
    }

    public function update($newType, $name)
    {
        $newType->name = $name;
        $newType->save();

        return $newType;
    }
}
