<?php
namespace App\Services\Contability;

use App\Domicilio;
use App\PodOrder;
use App\DomicilioProduct;
use App\PodOrderProduct;
use App\Storage;
use App\Helpers\Helper;
use Log;
use App\Http\Resources\Pod\PodReportCollection;
use App\Http\Resources\Domicilio\DomicilioReportCollection;
use Carbon\Carbon;
use App\Traits\ApiResponser;
use DB;

/**
 *
 */
class MainServices
{
    use ApiResponser;
    //construct
    public $start, $end, $total, $initMonth, $endMonth, $monthlySellInfo, $dates, $totalMonthDay;

    function __construct()
    {
        $this->start = Carbon::now()->format('Y-m-d');
        $this->end = Carbon::now()->format('Y-m-d');
        $this->initMonth = Carbon::now()->startOfMonth();
        $this->endMonth = Carbon::now()->endOfMonth();
        $this->total = 0;
        $this->monthlySellInfo = array();
        $this->dates = [];
        $now = Carbon::now();
        $this->totalMonthDay = Carbon::now()->month(substr($this->initMonth, 5, 2))->daysInMonth;
    }

    public function sells($user, $date, $date2, $type) {
        try {
            $mainId = $user->getIdMain($user);
            // init query
            $domicilios = Domicilio::where('user_id', '=', $mainId)
            ->where('status', '!=', 5);
            $pos = PodOrder::where('user_id', '=', $mainId);
            if ($user->type == 4) {
                $domicilios = $domicilios->where('storage_id', '=', $user->storage_id);
                $pos = $pos->where('storage_id', '=', $user->storage_id);
            }
            // validate query
            $start = $date ? $date .' 00:00:00' : $this->start .' 00:00:00';
            $end = $date2 ? $date2 .' 23:59:00' : $this->end .' 23:59:00';
            if ($date) {
                $domicilios = $domicilios->whereBetween('date_pay', [$start, $end])
                ->get();
                $pos = $pos->whereBetween('created_at', [$start, $end])
                ->get();
                if ($type == 1)
                    $this->total = ($domicilios->sum('total') + $pos->sum('total')) - $pos->sum('credit_apply');
                if ($type == 2)
                    $this->total = ($domicilios->sum('utilities') + $pos->sum('utilities'));
                if ($type == 3)
                    $this->total = (count($domicilios) + count($pos));
            }
            return ['total' => $this->total];
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function getTotalPurse($user) {
        try {
            return ['total' => $user->PurseUser->total_negative];
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function monthSell($user) {
        $mainId = $user->getIdMain($user);

        $domicilios = Domicilio::select(
            DB::raw("(SUM(total)) as total"),
            DB::raw("MONTHNAME(created_at) as month")
        )
        ->whereYear('created_at', date('Y'))
        ->where('user_id', '=', $mainId)
        ->groupBy('month')
        ->get()
        ->toArray();
        $pos = PodOrder::select(
            DB::raw("(SUM(total)) as total"),
            DB::raw("MONTHNAME(created_at) as month")
        )
        ->where('user_id', '=', $mainId)
        ->whereYear('created_at', date('Y'))
        ->groupBy('month')
        ->get()
        ->toArray();
        $sellsMont = [];
        if (count($domicilios) > count($pos)) {
            foreach ($domicilios as $dom => $domicilio) {
                foreach ($pos as $pod => $po) {
                    if ($domicilio['month'] == $po['month']) {
                        $domicilio['total'] = ($domicilio['total'] + $po['total']);
                    }
                }
                array_push($sellsMont, $domicilio);
            }
        } else {
            foreach ($pos as $pod => $po) {
                foreach ($domicilios as $dom => $domicilio) {
                    if ($po['month'] == $domicilio['month']) {
                        $po['total'] = ($po['total'] + $domicilio['total']);
                    }
                }
                array_push($sellsMont, $po);
            }
        }
        return $sellsMont;
    }

    public function countTypeSells($user) {
        $mainId = $user->getIdMain($user);
        $domicilios = Domicilio::where('user_id', '=', $mainId)
        ->get()
        ->count();
        $pos = PodOrder::where('user_id', '=', $mainId)
        ->get()
        ->count();
        $data['name'] = 'Ordenes';
        $data['total'] = $domicilios;
        $data2['name'] = 'Pos';
        $data2['total'] = $pos;
        $sellsMont = [$data, $data2];
        return $sellsMont;
    }

    public function getStorageSeller($user) {
        $mainId = $user->getIdMain($user);
        $storages = Storage::where('storages.user_id', '=', $mainId)
        ->get();
        $storagesTotal = [];
        foreach ($storages as $key => $value) {
            $totalDomicilio = Domicilio::where('storage_id', '=', $value->id)->get()->count();
            $totalPos = PodOrder::where('storage_id', '=', $value->id)->get()->count();
            $data['storage'] = $value->description;
            $data['total'] = ($totalDomicilio + $totalPos);
            array_push($storagesTotal, $data);
        }
        return $storagesTotal;
    }

    public function getBestSell($user) {
        $mainId = $user->getIdMain($user);
        $bestDomilicio = DB::table('products')
        ->leftJoin('domicilio_products','products.id','=','domicilio_products.product_id')
        ->selectRaw('products.name, COALESCE(sum(domicilio_products.quantity),0) total')
        ->where('user_id', '=', $mainId)
        ->groupBy('products.name')
        ->orderBy('total','desc')
        ->take(10)
        ->get();
        $bestPos = DB::table('products')
        ->leftJoin('pod_order_products','products.id','=','pod_order_products.product_id')
        ->selectRaw('products.name, COALESCE(sum(pod_order_products.quantity),0) total')
        ->where('user_id', '=', $mainId)
        ->groupBy('products.name')
        ->orderBy('total','desc')
        ->take(10)
        ->get();
        $bestSell = [];
        foreach ($bestDomilicio as $dom => $domicilio) {
            foreach ($bestPos as $pos => $pod) {
                if ($domicilio->name == $pod->name) {
                    $domicilio->total = ($domicilio->total + $pod->total);
                }
            }
            array_push($bestSell, $domicilio);
        }
        return $bestSell;
    }

    // get sellets diary
    public function getDiarySells($user, $month) {
        try {
            $mainId = $user->getIdMain($user);
            $requestMonth = Carbon::now()->month($month);
            $initMonth = substr($requestMonth->startOfMonth(), 0, 10);
            $endMonth = substr($requestMonth->startOfMonth(), 0, 8) . $requestMonth->daysInMonth;
            $totalMonthDay = Carbon::now()->month(substr($initMonth, 5, 2))->daysInMonth;
            // init vars
            $i = 0;
            // load domicilios
            $domicilios = DB::table('domicilios')->whereBetween('date_pay', [$initMonth, $endMonth])
            ->where('user_id', $mainId)
            ->groupBy( 'date_pay' )
            ->get( [
                DB::raw( 'DATE( date_pay ) as day' ),
                DB::raw( 'SUM(total) AS "total"' )
            ])->toArray();
            // load pos
            $pos = DB::table('pod_orders')->whereBetween('created_at', [$initMonth, $endMonth])
            ->where('user_id', $mainId)
            ->groupBy('created_at')
            ->get( [
                DB::raw( 'DATE( created_at ) as day' ),
                DB::raw( 'SUM(total) AS "total"' )
            ])->toArray();
            //llenamos el arreglo principal
            while($i < $totalMonthDay) {
                $date = $requestMonth->startOfMonth()->addDays($i)->format( 'Y-m-d' );
                $data['day'] = $date;
                $data['total'] = 0;
                array_push($this->dates, $data);
                $i++;
            }
            // validamos los datos
            $ordersArr = [];
            $returnData = [];
            foreach ($this->dates as $days => $day) {
                foreach ($domicilios as $orders => $order) {
                    if ($day['day'] == $order->day) {
                        $day['total'] = $day['total'] + $order->total;
                    }
                }
                array_push($ordersArr, $day);
            }
            // validamos los pos
            foreach ($ordersArr as $sell => $sellData) {
                foreach ($pos as $pod => $posOrder) {
                    if ($sellData['day'] == $posOrder->day) {
                        $sellData['total'] = $sellData['total'] + $posOrder->total;
                    }
                }
                array_push($returnData, $sellData);
            }
            return $returnData;
        } catch (\Exception $e) {
            $this->errorUnprocessableEntityResponse($e->getMessage());
        }
    }
}
