<?php

namespace App\Http\Resources\Product;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Storage\ProductStoragePosCollection;
use App\Http\Resources\Price\ProductPricesPosCollection;
use App\Http\Resources\ProductVariants\ProductVariantsPosCollection;
use App\ProductVariants;
use Log;

class ProductPosResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $variants = [];
        if (isset($this->variant)) {
            $data = collect($this->variant->toArray());
            $variants = ProductVariants::where('id', $data['id'])->where('user_id', $this->user_id)->get();
        }
        return [
            'name' => $this->name,
            'sku' => $this->sku,
            'value' => $this->utilities,
            'type' => $this->type,
            'unit_of_measurement' => $this->unit_of_measurement,
            'tax' => $this->tax,
            'stock_quantity' => $this->stock_quantity,
            'id' => $this->id,
            'storages' => new ProductStoragePosCollection($this->Storages),
            'price' => $this->price,
            'prices' => new ProductPricesPosCollection($this->prices),
            'variants' => count($variants) > 0 ? new ProductVariantsPosCollection($variants) : new ProductVariantsPosCollection($this->ProductVariants)
        ];
    }
}
