<?php

namespace App\Http\Resources\PreInvoice;

use Illuminate\Http\Resources\Json\JsonResource;

use App\Http\Resources\Domiciliario\DomiciliarioResource;
use App\Http\Resources\DomicilioProduct\DomicilioProductsCollection;
use App\Http\Resources\Status\StatusCollection;
use App\Http\Resources\User\UserResource;
use App\Http\Resources\Seller\SellerResource;
use App\Http\Resources\Domicilio\DomicilioResource;
use App\Http\Resources\DomicilioPayment\DomicilioPaymentCollection;
use Illuminate\Support\Arr;
use App\PaymentReceived;
use App\CostCenter;

class PreInvoiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'reference' => $this->reference,
            'channel' => $this->channel,
            'observation'  => $this->observation,
            'price'  => $this->price,
            'delivery'  => $this->delivery,
            'total'  => $this->total,
            'total_payment'  => $this->total_payment,
            'purse' => ($this->total - $this->total_payment),
            'status'  => $this->status,
            'taxt'  => $this->taxt,
            'tax_total'  => $this->tax_total,
            'is_pay'  => $this->is_pay,
            'name'  => $this->name,
            'subtotal'  => $this->subtotal,
            'discountTotal'  => $this->discount,
            'discount'  => $this->discount_porcent,
            'utilities'  => $this->utilities,
            'name'  => $this->Client ? $this->Client->name : 'No posee',
            'phone'  => $this->Client ? $this->Client->phone : 'No posee',
            'dni'  => $this->Client ? $this->Client->dni : 'No posee',
            'address'  => $this->Client ? $this->Client->address : 'No posee',
            'email'  => $this->Client ? $this->Client->email : 'No posee',
            'liquidad'  => $this->is_liquidado,
            'garantia'  => $this->is_warranty,
            'type'  => 4,
            'returns' => $this->Returns ? true : false,
            'load_web'  => $this->load_web ? true : false,
            'is_credit'  => $this->is_credit,
            'storage_id'  => $this->storage_id,
            'storage'  => $this->Storage,
            'seller_id'  => $this->seller_id,
            'client'  => $this->Client,
            'clientTypeDoc' => $this->Client ? $this->Client->DocumentType : '',
            'pending' => $this->is_credit ? $this->getPending() : 0,
            'date'  => $this->created_at->format('d-m-Y'),
            'credit'  => $this->is_credit ? 'Credito' : 'No credito.',
            'seller'  => new SellerResource($this->Seller),
            'products'  => new DomicilioProductsCollection($this->Products),
            'user'  => new UserResource($this->User),
            'expiration_date' => $this->expiration_date,
            'upon_delivery' => $this->upon_delivery ? true : false,
            'hora' => $this->created_at->format('d-m-Y H:s'),
            'cost_center_id' => $this->cost_center_id,
            'cost_center' => $this->cost_center_id > 0 ? CostCenter::find($this->cost_center_id) : 'Por defecto',
            'global_price' => $this->global_price,
            'remaining' => $this->total - $this->total_payment,
            'status_pre_invoice' => $this->status_pre_invoice,
            'order' => $this->Domicilio ? new DomicilioResource($this->Domicilio) : null
        ];
    }
}