<?php

namespace App\Http\Resources\Domiciliario;

use App\DomiciliarioHasCities;
use Illuminate\Http\Resources\Json\JsonResource;
use App\User;

class DomiciliarioResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $user = User::where('domiciliario_id', $this->id)->first();
        $city = DomiciliarioHasCities::where('domiciliario_id', $this->id)->first();
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email, // HERC
            'dni' => $this->dni,
            'phone'  => $this->phone,
            'password'  => $this->password, // HERC
            'hiring_method' => $this->hiring_method,
            'city' => $city ? $city->city_id : null,
            'plate' => $this->placa
        ];
    }
}
