<?php

namespace App\Http\Requests\User;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            //
            'name' => [
                'required',
                'string',
                'max:60',
                Rule::unique('users', 'name')
                    ->ignore($this->id, 'id')
            ],
            'email' => [
                'required',
                'email',
                'max:90',
                Rule::unique('users', 'email')
                    ->ignore($this->id, 'id')
            ],
            'password' => [
                Rule::requiredIf(function () {
                    return !$this->id;
                }),
                'min:8',
                'max:30',
                'regex:/^(?=.*[a-z])(?=.*[A-Z]).{8,}$/',
            ],
            'role_id' => 'numeric'
        ];
    }

    /**
     * messages for validations
     */
    public function messages()
    {
        return [
            'name.required' => 'El nombre de usuario es requerido.',
            'name.string' => 'El nombre de usuario debe ser una cadena.',
            'name.unique' => 'El nombre de usuario se encuentra en uso.',
            'name.max' => 'El nombre de usuario debe contener máximo 60 caracteres.',
            'email.required' => 'El correo de usuario es requerido.',
            'email.email' => 'El correo de usuario debe ser un correo valido.',
            'email.unique' => 'El correo de usuario se encuentra en uso.',
            'email.max' => 'El correo de usuario debe contener máximo 90 caracteres.',
            'password.required' => 'La contraseña es requerida',
            'password.min' => 'La contraseña debe poseer minimo 8 caracteres',
            'password.max' => 'La contraseña debe poseer maximo 30 caracteres',
            'password.regex' => 'La contraseña debe poseer una letra mayúscula y una minúscula.',
            'role_id.required' => 'El rol id es requerido',
            'role_id.numeric' => 'El rol id debe ser numerico'
        ];
    }
}
