<?php

namespace App\Http\Requests\Parameters;

use Illuminate\Foundation\Http\FormRequest;

class ParameterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "name" => "required|min:3|max:50",
            "type" => "required|min:3|max:50",
            "value" => "required",
            "description" => "nullable|max:255"
        ];
    }

    public function messages()
    {
        return [
            "name.required" => "El nombre del parámetro es requerido",
            "name.min" => "El nombre del parámetro requiere mínimo 3 caracteres",
            "name.max" => "El nombre del parámetro no puede tener más de 50 caracteres",
            "type.required" => "El tipo del parámetro es requerido",
            "type.min" => "El tipo del parámetro requiere mínimo 3 caracteres",
            "type.max" => "El tipo del parámetro no puede tener más de 50 caracteres",
            "value.required" => "El valor del parámetro es requerido",
            "description.max" => "La descripción no puede tener más de 255 caracteres"
        ];
    }
}
