<?php

namespace App\Http\Requests\Domicilio;

use Illuminate\Foundation\Http\FormRequest;
use App\Enums\TypeDomicilioSolutionConst;

class SolveDomicilioRequest extends FormRequest
{
    /**
     * Determina si el usuario está autorizado para hacer esta solicitud.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Obtiene las reglas de validación que se aplican a la solicitud.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            "type_solution" => "required|integer",
            "file" => "nullable|image|max:10000",
        ];

        // Reglas condicionales para cuando `type_solution` es 1
        if ($this->input('type_solution') == TypeDomicilioSolutionConst::RESCHEDULING) {
            $rules['data'] = 'required|array';
            $rules['data.date'] = 'required|date';
            $rules['data.startTime'] = ['required', 'regex:/^(2[0-3]|[01]?[0-9]):[0-5][0-9]$/'];
            $rules['data.endTime'] = ['required', 'regex:/^(2[0-3]|[01]?[0-9]):[0-5][0-9]$/'];
            $rules['data.description'] = 'required|string|max:100|min:5';
        }

        return $rules;
    }

    /**
     * Obtiene los mensajes personalizados de error para la validación.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'data.required' => 'El campo data es obligatorio cuando type_solution es 1.',
            'data.date.required' => 'El campo date es obligatorio dentro de data.',
            'data.startTime.required' => 'El campo startTime es obligatorio dentro de data.',
            'data.endTime.required' => 'El campo endTime es obligatorio dentro de data.',
            'data.description.required' => 'El campo description es obligatorio dentro de data.',
            'file.image' => 'El archivo debe ser una imagen válida.',
            'file.max' => 'El tamaño máximo permitido para la imagen es de 10MB.',
        ];
    }
}
