<?php

namespace App\Http\Requests\DispatchRelation;

use Illuminate\Foundation\Http\FormRequest;

class deleteOrderDispatchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "domicilio_id" => "required|exists:domicilios,id"
        ];
    }

    public function messages()
    {
        return [
            "domicilio_id.required" => "El id de la orden es requerido",
            "domicilio_id.exists" => "No existe la orden",
        ];
    }
}
