<?php

namespace App\Http\Requests\Configuration;

use Illuminate\Foundation\Http\FormRequest;

class SaveConfigurationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'brand_name' => 'string|max:59',
            'brand_color' => 'string|max:10',
            'guide_footer' => 'string|max:90',
            'format_guide' => 'string',
            'brand_logo' => 'file|mimes:jpeg,png,jpg,webp|max:2048',
            'brand_mini_logo' => 'file|mimes:jpeg,png,jpg,webp|max:2048',
            'brand_img' => 'file|mimes:jpeg,png,jpg,webp|max:2048',
        ];
    }
}
