<?php

namespace App\Http\Middleware;

use Closure;
use App\Traits\ApiResponser;

class DropiServices
{
    use ApiResponser;

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $token = $request->header('Custom-Auth-Token');
        if (!isset($token))
            return $this->errorResponse('Configura tu token de acceso a OnexDelivery.', 401);

        if ($token != env("CUSTOM_AUTH_TOKEN"))
            return $this->errorResponse('Tu token de acceso es invalido.', 401);

        return $next($request);
    }
}
