<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\External\ExternalService;

class ExternalFunctionsController extends Controller
{
    private $externalService;

    public function __construct(ExternalService $externalService)
    {
        $this->externalService = $externalService;
    }

    public function getDomiciliosNews($reference)
    {
        try {
            $domiciliosNews = $this->externalService->getDomiciliosNews($reference);
            return response()->json($domiciliosNews);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
