<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Http\Resources\User\UserResource;
use App\Http\Resources\User\UserCollection;
use App\Http\Controllers\AuditController;
use App\Http\Requests\Auth\RegisterForAdminRequest;
use App\Http\Requests\Auth\LoginRequest;
use App\Http\Requests\Auth\ImageRequest;
use App\Http\Requests\Auth\EditUser;
use App\User;
use App\Helpers\Helper;
use Response;
use Carbon\Carbon;
use DB;
use Illuminate\Support\Facades\Event;
use App\Events\Auth\ChangePassword;
use App\Traits\ApiResponser;
use App\Http\Requests\User\UserRequest;

class AuthController extends Controller
{
    use ApiResponser;

    // asignamos el usuario de cada domiciliario
    public static function register($email, $username, $password, $domiciliario) {
    	if (User::Email($email)->count() > 0) {
            return ['error' => 'El correo se encuentra en uso.'];
        }
        if (User::Name($username)->count() > 0) {
            return ['error' => 'El nombre de usuario se encuentra en uso.'];
        }
        $user = User::create([
            'name' => $username,
            'email' => $email,
            'password' => Hash::make($password),
            'type' => 3,
            'domiciliario_id' => $domiciliario,
            'role_id' => 5,
        ]);
        return Helper::response('success', 'Se ha creado el usuario para el domiciliario correctamente.', 201);
    }

     // registramos desde la seccionde usuario en el admin
    public static function registerForAdmin(RegisterForAdminRequest $request) {
        try {
            $mainId = $request->user()->getIdMain($request->user());
            // guardamos el usuario
            $user = User::create([
                'name' => $request->name,
                'email' => $request->email,
                'password' => Hash::make($request->password),
                'type' => $request->type,
                'storage_id' => $request->storage_id
            ]);
            // purse user valdiation and creation
            if ($user->type == 2) {
                $purse = PurseUser::where('user_id', $user->id)->first();
                if (!$purse) {
                    PurseUser::create(['user_id' => $user->id]);
                }
            }
            // si existe el usuario principal se le configura a el usuario creado
            if ($request->has('ownUser'))
                $user->update(['parent_id' => $request->ownUser]);
            // creamos la data primaria del ecommercer solo si existe en nombre de la marca
            $userEcoomerce = Ecommerce::create([
                'user_id' => $user->id
            ]);
            // guardamos la auditoria
            AuditController::store($request->user()->name, ' Ha creado el usuario con el nombre: ' .$request->name, 'Usuarios', $mainId);
            // retornamos la respuesta
            return Helper::response('success', 'Se ha creado el usuario correctamente.', 201);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    // inicio sesión
    public function login(LoginRequest $request) {
        // obtenemos el usuario por el nombre de usuario
        $user = User::where('name', $request->username)
        ->orWhere('email', $request->username)
        ->first();
        // si existe el usuario procedemos a validar las contraseñas.
        if ($user) {
            // si las contraseñas concuerdann.
            if (Hash::check($request->password, $user->password)) {
                // generamos el auth token.
                $token = $user->createToken('USER AUTH TOKEN')->accessToken;
                // retornamos la respuesta con el token.
                $response = ['token' => $token, 'user' => new UserResource($user)];
                return Helper::response('success', $response, 200);
            } else {
                // si las contraseñas no concuerdan retornamos.
                return Helper::response('error', 'La contraseña es incorrecta.', 400);
            }
        } else {
            // si el usuario no existe retornamos.
            return Helper::response('error', 'El usuario no existe.', 400);
        }
    }

    // cierro sesión
    public function logout(Request $request) {
        try {
            // obtenemos el token del usuario
            $token = $request->user()->token();
            // revocamos el token
            $token->revoke();
            // retornamos respuesta
            return Helper::response('success', 'Se ha cerrado la sesión correctamente.', 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function index(Request $request) {
        try {
            $mainId = $request->user()->getIdMain($request->user());
            // si el tipo de usuario es admon retornamos todos los usuarios de tipo cliente
            if ($request->user()->type == 1)
                $users = User::Desc()->where('type', 2)->get();
            // si el usuario es de tipo cliente retirnamos los usuario de tipo trabajador
            else
                $users = User::Desc()->Type()->Parent($mainId)->get();
            return Helper::response('users', new UserCollection($users), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function updatePhoto(ImageRequest $request) {
        try {
            // obtenemos el usuario logueado
            $user = User::findOrFail($request->user()->id);
            if ($user->photo != 'default-profile') {
                Helper::deleteFile($user->photo, 'profile');
            }
            $path = Helper::uploadImage($request->file, 'profile');
            $user->update(['photo' => $path]);
            return Helper::response('user', new UserResource($user), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    //Modificamos los datos de acceso por cada usuario
    public function updateProfile(UserRequest $request) {
        try {
            // sacamos el id principal
            $mainId = $request->user()->getIdMain($request->user());
            // get sacamos el usuario
            $user = User::findOrFail($request->id);
            // modificamos el nombre
            if ($request->has('name'))
                $user->update(['name' => $request->name]);
            // modificamos el email
            if ($request->has('email'))
                $user->update(['email' => $request->email]);
            // modificamos la contraseña
            if ($request->has('passwordN')) {
                if (Hash::check($request->password, $user->password)) {
                    $user->update(['password' => Hash::make($request->passwordN)]);
                } else {
                    return Helper::response('errors', array(0=> 'Contraseña actual errada.'), 400);
                }
            }
            AuditController::store($request->user()->name, ' Ha modificado sus datos de acceso.', 'Usuarios', $mainId);
            return Helper::response('user', new UserResource($user), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    // editamos el perfil de logueo por admin
    public function edit(EditUser $request) {
        try {
            $user = User::findOrFail($request->id);
            $user->update(['name' => $request->name,'email' => $request->email,'type' => $request->type,'storage_id' => $request->storage_id]);
            if ($request->has('password'))
                $user->update(['password' => Hash::make($request->password)]);
            // get id of user main
            $mainId = $request->user()->getIdMain($request->user());
            AuditController::store($request->user()->name, ' Ha modificado los datos de acceso del usuario: ' . $user->name, 'Usuarios', $mainId);
            return Helper::response('success', 'Se han modificado los datos del usuario correctamente.', 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    //borramos el usuario
    public function delete(Request $request) {
        try {
            $user = User::findOrFail($request->id);
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
            $user->delete();
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
            $mainId = $request->user()->getIdMain($request->user());
            AuditController::store($request->user()->name, 'Ha borrado el usuario con el nombre: ' .$user->username, 'Usuarios', $mainId);
            return Helper::response('success', 'Se han eliminado los datos del usuario correctamente.', 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    //guardamos la data del woocomerce
    public function removeWoocommerce(Request $request) {
        try {
            // validamos y seteamos el woocomerce url
            $url = EcommerceConfig::where('key', 'woocomerce_url')->where('user_id', $request->user()->id)->first();
            if (!is_null($url)) {
                $url->update(['value' => null]);
            }

            //validamos y seteamos el woocomerce ck
            $ck = EcommerceConfig::where('key', 'woocomerce_ck')->where('user_id', $request->user()->id)->first();
            if (!is_null($ck)) {
                $ck->update(['value' => null]);
            }

            //validamos y seteamos el woocomerce cs
            $cs = EcommerceConfig::where('key', 'woocomerce_cs')->where('user_id', $request->user()->id)->first();
            if (!is_null($cs)) {
                $cs->update(['value' => null]);
            }

            // por el momento seguimos guardando la data del ecommerce como tal
            $request->user()->update([
                'woocomerce_ck' => null,
                'woocomerce_cs' => null,
                'woocomerce_url' => null,
                'has_woocommerce' => null,
            ]);
            return Helper::response('user', new UserResource($request->user()), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    // recuperar contraseña
    public function recovery(Request $request) {
        try {
            // validamos el nombre de usuario
            $user = User::Name($request->username)->first();
            if ($user) {
                // verificamos si posee una recuperacion en proceso
                $isset = DB::select('select * from reset_password where user_id = :id and expired > :now', ['id' => $user->id, 'now' => Carbon::now()]);
                // si posee un proceso activo retornamos
                if ($isset) {
                    return Helper::response('error', 'El usuario posee un proceso de recuperación activo. Verifica tu correo.', 400);
                }
                // generamos un codigo de recuperación
                $token = Helper::generateReference(12);
                $user->token = $token;
                //generamos las fechas
                $now = Carbon::now();
                $expired = Carbon::now()->addMinutes(30);
                // insertamos el token de recuperacion en la bbdd
                DB::insert('insert into reset_password (token, expired, user_id) values (?, ?, ?)', [$token, $expired, $user->id]);
                // ejecutamos el evento de changepassword para enviar el email
                Event::dispatch(new ChangePassword($user));
                return Helper::response('success', 'Se ha enviado un codigo de verificación a tu correo electronico.', 200);
            } else {
                return Helper::response('error', 'El usuario ingresado no existe en nuestros registro.', 400);
            }
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    // verificamos el token para cambiar la contraseña
    public function changePasswordForToken(Request $request) {
        try {

            // validamos si existe el token en la bbdd
            $token = DB::select('select * from reset_password where token = :token', ['token' => $request->token]);
            if ($token) {
                // validamos si el token a expirado o no
                if ($token[0]->expired < Carbon::now()) {
                    return Helper::response('error', 'El token ingresado expiro, por favor solicita uno nuevo.', 400);
                }
                // buascamos el isiarop por el id de usuario token
                $user = User::where('id', '=', $token[0]->user_id)->first();
                //if isset user change password
                if ($user) {
                    $user->update(['password' => Hash::make($request->password)]);
                    // delete used token
                    DB::table('reset_password')->where('id', '=', $token[0]->id)->delete();
                    return Helper::response('success', 'Se ha cambiado la contraseña.', 200);
                }

            } else {
                return Helper::response('error', 'El token ingresado no existe, por favor verificalo en tu correo electronico.', 400);
            }
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    // return user
    public function showAuth(Request $request) {
        try {
            return $this->successResponse(new UserResource($request->user()));
        } catch (\Exception $e) {
            return $this->errorUnprocessableEntityResponse($e->getMessage());
        }
    }
}
