<?php
namespace App\Helpers;
use File;

use App\Domicilio;
use Automattic\WooCommerce\Client;
use Illuminate\Support\Facades\Log;
use Response;

/**
 *
 */
class Helper
{
	 //upload file
    public static function uploadImage($file, $pathModel) {
        $name = date('Ymd_His') . '.webp';
        $file->move('images/'.$pathModel, $name);
        return $name;
    }

    //delete file
    public static function deleteFile($file, $pathModel) {
        $oldfile = public_path('images/'.$pathModel.'/'.$file);
        if (File::exists($oldfile)) {
            unlink($oldfile);
        }
    }

    // add reference
    public static function generateReference($length) {
        $key = '';
        $keys = array_merge(range(0, 6), range('A', 'Z'));
        for ($i = 0; $i < $length; $i++) {
            $key .= $keys[array_rand($keys)];
        }
        return $key;
    }

    // response
    public static function response($status, $message, $code) {
        $response = Response::make(json_encode([$status => $message]), $code)->header('Content-Type','application/json');
        return $response;
    }

    // generate Label of attributes
    public static function generateLabel($attributes) {
        $label = '';
        foreach ($attributes as $termAtr => $termAttr) {
            if (count($attributes) > 1)
                $label = $label . ' - ' . @$termAttr->option ?? $termAttr['option'];
            else
                $label = $label . @$termAttr->option ?? $termAttr['option'];
        }
        return $label;
    }

    // get from woocomerce
    public static function getWoocomerce($url, $user) {
        if ($user->has_woocommerce) {
            // get woocomerce data
            $wooData = $user->getWooKeys($user->type, $user);

            //set woocomerce data
            $wooCommerce = new Client(
                $wooData['url'],
                $wooData['ck'],
                $wooData['cs'],
                [
                    'wp_api' => true,
                    'version' => 'wc/v3',
                    'timeout' => 300000
                ]
            );

            // send post to woocomerce
            $get = $wooCommerce->get($url . '?per_page=100&page=1');

            // return response
            return $get;
        }
    }

    // post to woocomerce
    public static function createInWoocomerce($data, $url, $user, $type) {
        if ($user->has_woocommerce) {
            // get woocomerce data
            $wooData = $user->getWooKeys($user->type, $user);

            //set woocomerce data
            $wooCommerce = new Client(
                $wooData['url'],
                $wooData['ck'],
                $wooData['cs'],
                [
                    'wp_api' => true,
                    'version' => 'wc/v3',
                    'timeout' => 300000
                ]
            );
            // send post to woocomerce
            if ($type == 1) {
                $productInWoocommerce = $wooCommerce->post($url, $data);
            } else {
                $productInWoocommerce = $wooCommerce->put($url, $data);
            }

            // decode response
            $productInWoocommerce = json_encode($productInWoocommerce, true);
            $decodeWoocomerce = json_decode($productInWoocommerce, true);

            // return response
            return $decodeWoocomerce;
        }
    }

    // delete from woocomerce
    public static function deleteInWoocomerce($url, $user) {
        if ($user->has_woocommerce) {
            // get woocomerce data
            $wooData = $user->getWooKeys($user->type, $user);

            //set woocomerce data
            $wooCommerce = new Client(
                $wooData['url'],
                $wooData['ck'],
                $wooData['cs'],
                [
                    'wp_api' => true,
                    'version' => 'wc/v3',
                    'timeout' => 300000
                ]
            );

            // send post to woocomerce
            $delete = $wooCommerce->delete($url, ['force' => true]);

            // return response
            return $delete;
        }
    }

    public static function filterWoocomerce($url, $user) {
        if ($user->has_woocommerce) {
            // get woocomerce data
            $wooData = $user->getWooKeys($user->type, $user);


            //set woocomerce data
            $wooCommerce = new Client(
                $wooData['url'],
                $wooData['ck'],
                $wooData['cs'],
                [
                    'wp_api' => true,
                    'version' => 'wc/v3'
                ]
            );

            // send post to woocomerce
            $get = $wooCommerce->get($url);

            // return response
            return $get;
        }
    }

    // genero las convinaciones de categorias
    public static function variations($array) {
        if (empty($array)) {
            return [];
        }

        $keys = [];
        $size = 1;

        foreach ($array as $key => $elems) {
            if (is_array($elems)) {
                $rr = [];

                foreach ($elems as $ind => $elem) {
                    if (is_array($elem)) {
                        $rr = array_merge($rr, $this->traverse($elem, $ind));
                    } else {
                        $rr[] = $elem;
                    }
                }

                $array[$key] = $rr;
                $size *= count($rr);
            }

            $keys[] = $key;
        }

        $rez = [];
        for ($i = 0; $i < $size; $i++) {
            $rez[$i] = [];

            foreach ($array as $key => $value) {
                $current = current($array[$key]);
                $rez[$i][$key] = $current;
            }

            foreach ($keys as $key) {
                if (!next($array[$key])) {
                    reset($array[$key]);
                } else {
                    break;
                }
            }
        }

        return $rez;
    }

    public function traverse($array, $parent_ind) {
        $r = [];
        $pr = '';

        if(!is_numeric($parent_ind)) {
            $pr = $parent_ind.'-';
        }

        foreach ($array as $ind => $el) {
            if (is_array($el)) {
                $r = array_merge($r, $this->traverse($el, $pr.(is_numeric($ind) ? '' : $ind)));
            } elseif (is_numeric($ind)) {
                $var['id'] = $parent_ind;
                $var['option'] = $pr.$el;
                $r[] = $var;
            } else {
                $pr.$ind.'-'.$el;
            }
        }

        return $r;
    }

    //check file exist
    public static function validateFile ($file) {
        $oldfile = public_path('ticket/'.$file);
        if (File::exists($oldfile)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     *
     * Remove tildes
     */
    public static function deleteTilde($cadena) {
        //Ahora reemplazamos las letras
        $cadena = str_replace(
            array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
            array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
            $cadena
        );
        $cadena = str_replace(
            array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
            array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
            $cadena );
        $cadena = str_replace(
            array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
            array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
            $cadena );
        $cadena = str_replace(
            array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
            array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
            $cadena );
        $cadena = str_replace(
            array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),
            array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),
            $cadena );
        return $cadena;
    }

    // get from woocomerce
    static function paginateWoocomerce($url, $user, $page) {
        if ($user->has_woocommerce) {
            // get woocomerce data
            $wooData = $user->getWooKeys($user->type, $user);
            //set woocomerce data
            $wooCommerce = new Client(
                $wooData['url'],
                $wooData['ck'],
                $wooData['cs'],
                [
                    'wp_api' => true,
                    'version' => 'wc/v3',
                    'timeout' => 300000
                ]
            );
            // get woocomerce data
            $get = $wooCommerce->get($url . '?per_page=100&page='.$page, $user);
            // return response
            return $get;
        }
    }
}
