<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\HasContentCount;
use App\Traits\HasCollectionValueCount;

class Domicilio extends Model
{
    use SoftDeletes, HasContentCount, HasCollectionValueCount;

    //fillable
    protected $fillable = [
        'reference',
        'city_id',
        'zone_id',
        'payment_method_id',
        'aditional_payment',
        'comprobant',
        'observation',
        'price',
        'delivery',
        'total',
        'status',
        'domiciliario_id',
        'client_id',
        'type',
        'invoice_url',
        'log_sender_id',
        'liquidated',
        'content',
        'location',
    ];

    protected $appends = [
        'content_count',
        'collection_values_count'
    ];

    //relations
    public function Collections()
    {
        return $this->hasMany('App\DomicilioCollection', 'domicilio_id');
    }

    public function News()
    {
        return $this->hasMany('App\DomicilioNews', 'domicilio_id');
    }

    public function Evidences()
    {
        return $this->hasMany('App\Evidence', 'domicilio_id');
    }

    public function domiciliario()
    {
        return $this->belongsTo('App\Domiciliario');
    }

    public function Products()
    {
        return $this->hasMany('App\DomicilioProduct');
    }

    public function statusDomicilio()
    {
        return $this->hasMany('App\Status');
    }

    public function Client()
    {
        return $this->belongsTo('App\Client');
    }

    // HERC
    public function logSender()
    {
        return $this->belongsTo(LogSender::class);
    }

    public function payment_method()
    {
        //return PaymentMethods::where("id",$this->payment_method_id)->first();
        return $this->belongsTo(PaymentMethod::class);
    }

    public function settlements()
    {
        return $this->belongsToMany(
            Settlement::class,
            'domicilio_has_settlements',
            'domicilio_id',
            'settlement_id'
        );
    }

    public function reschedules()
    {
        return $this->hasMany(DomiciliosRescheduling::class, 'domicilio_id');
    }

    public function zone()
    {
        return $this->belongsTo(Zone::class);
    }

    public function dropshipper()
    {
        return $this->hasMany(DropshipperSettlement::class);
    }
}
