<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\User;
use App\City;

class CoordinatorHasCity extends Model
{
    protected $fillable = [
        'user_id',
        'city_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function cities()
    {
        return $this->belongsToMany(City::class);
    }
}
